/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.reporting;

import com.microsoft.bingads.v13.internal.reporting.RowReport;
import com.microsoft.bingads.v13.internal.reporting.XmlReport;
import com.microsoft.bingads.v13.reporting.Report;
import com.microsoft.bingads.v13.reporting.ReportFormat;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public class ReportFileReader
implements Closeable {
    private Report report;
    private String reportFilePath;

    public ReportFileReader(String filePath, ReportFormat format) throws IOException, XMLStreamException {
        this(new File(filePath), format);
    }

    public ReportFileReader(File file, ReportFormat format) throws IOException, XMLStreamException {
        this.reportFilePath = file.getCanonicalPath();
        switch (format) {
            case CSV: 
            case TSV: {
                this.report = new RowReport(file, format);
                break;
            }
            case XML: {
                this.report = new XmlReport(file);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.report != null) {
            this.report.close();
            this.report = null;
        }
    }

    public Report getReport() {
        return this.report;
    }

    public String getReportFilePath() throws IOException {
        return this.reportFilePath;
    }
}

