/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.restful;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.internal.restful.ResponseInfo;
import com.microsoft.bingads.internal.restful.RestfulServiceClient;
import com.microsoft.bingads.v13.customerbilling.AdApiFaultDetail;
import com.microsoft.bingads.v13.customerbilling.AdApiFaultDetail_Exception;
import com.microsoft.bingads.v13.customerbilling.AddInsertionOrderRequest;
import com.microsoft.bingads.v13.customerbilling.AddInsertionOrderResponse;
import com.microsoft.bingads.v13.customerbilling.ApiBatchFault;
import com.microsoft.bingads.v13.customerbilling.ApiBatchFault_Exception;
import com.microsoft.bingads.v13.customerbilling.ApiFault;
import com.microsoft.bingads.v13.customerbilling.ApiFault_Exception;
import com.microsoft.bingads.v13.customerbilling.ApplicationFault;
import com.microsoft.bingads.v13.customerbilling.CheckFeatureAdoptionCouponEligibilityRequest;
import com.microsoft.bingads.v13.customerbilling.CheckFeatureAdoptionCouponEligibilityResponse;
import com.microsoft.bingads.v13.customerbilling.ClaimFeatureAdoptionCouponsRequest;
import com.microsoft.bingads.v13.customerbilling.ClaimFeatureAdoptionCouponsResponse;
import com.microsoft.bingads.v13.customerbilling.DispatchCouponsRequest;
import com.microsoft.bingads.v13.customerbilling.DispatchCouponsResponse;
import com.microsoft.bingads.v13.customerbilling.GetAccountMonthlySpendRequest;
import com.microsoft.bingads.v13.customerbilling.GetAccountMonthlySpendResponse;
import com.microsoft.bingads.v13.customerbilling.GetBillingDocumentsInfoRequest;
import com.microsoft.bingads.v13.customerbilling.GetBillingDocumentsInfoResponse;
import com.microsoft.bingads.v13.customerbilling.GetBillingDocumentsRequest;
import com.microsoft.bingads.v13.customerbilling.GetBillingDocumentsResponse;
import com.microsoft.bingads.v13.customerbilling.ICustomerBillingService;
import com.microsoft.bingads.v13.customerbilling.RedeemCouponRequest;
import com.microsoft.bingads.v13.customerbilling.RedeemCouponResponse;
import com.microsoft.bingads.v13.customerbilling.SearchCouponsRequest;
import com.microsoft.bingads.v13.customerbilling.SearchCouponsResponse;
import com.microsoft.bingads.v13.customerbilling.SearchInsertionOrdersRequest;
import com.microsoft.bingads.v13.customerbilling.SearchInsertionOrdersResponse;
import com.microsoft.bingads.v13.customerbilling.UpdateInsertionOrderRequest;
import com.microsoft.bingads.v13.customerbilling.UpdateInsertionOrderResponse;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Response;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class CustomerBillingService
extends RestfulServiceClient
implements ICustomerBillingService {
    private Supplier<ICustomerBillingService> fallbackService;

    public CustomerBillingService(Map<String, String> headers, ApiEnvironment env, Supplier<ICustomerBillingService> fallbackService) {
        super(headers, env, ICustomerBillingService.class);
        this.fallbackService = fallbackService;
    }

    Exception processFaultDetail(ApplicationFault faultDetail, boolean shouldThrow) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        String message = this.getFaultMessage(faultDetail.getTrackingId());
        if (faultDetail instanceof AdApiFaultDetail) {
            AdApiFaultDetail_Exception ex = new AdApiFaultDetail_Exception(message, (AdApiFaultDetail)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (faultDetail instanceof ApiFault) {
            ApiFault_Exception ex = new ApiFault_Exception(message, (ApiFault)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (shouldThrow) {
            throw new RuntimeException("Unknown fault type: " + faultDetail.getClass());
        }
        return null;
    }

    Exception processFaultDetailApiBatchFault(ApplicationFault faultDetail, boolean shouldThrow) throws AdApiFaultDetail_Exception, ApiBatchFault_Exception, ApiFault_Exception {
        String message = this.getFaultMessage(faultDetail.getTrackingId());
        if (faultDetail instanceof AdApiFaultDetail) {
            AdApiFaultDetail_Exception ex = new AdApiFaultDetail_Exception(message, (AdApiFaultDetail)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (faultDetail instanceof ApiBatchFault) {
            ApiBatchFault_Exception ex = new ApiBatchFault_Exception(message, (ApiBatchFault)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (faultDetail instanceof ApiFault) {
            ApiFault_Exception ex = new ApiFault_Exception(message, (ApiFault)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (shouldThrow) {
            throw new RuntimeException("Unknown fault type: " + faultDetail.getClass());
        }
        return null;
    }

    protected <Req, Resp> Resp sendRequest(Req request, String entityEndpoint, String verb, Class<Resp> respClass) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        ResponseInfo<Resp, ApplicationFault> responseInfo = this.getResponseInfo(request, entityEndpoint, verb, respClass, ApplicationFault.class);
        if (responseInfo == null) {
            return null;
        }
        ApplicationFault faultDetail = responseInfo.getFaultDetail();
        if (faultDetail != null) {
            this.processFaultDetail(faultDetail, true);
        }
        return responseInfo.getResponse();
    }

    protected <Req, Resp> Resp sendRequestApiBatchFault(Req request, String entityEndpoint, String verb, Class<Resp> respClass) throws AdApiFaultDetail_Exception, ApiBatchFault_Exception, ApiFault_Exception {
        ResponseInfo<Resp, ApplicationFault> responseInfo = this.getResponseInfo(request, entityEndpoint, verb, respClass, ApplicationFault.class);
        if (responseInfo == null) {
            return null;
        }
        ApplicationFault faultDetail = responseInfo.getFaultDetail();
        if (faultDetail != null) {
            this.processFaultDetailApiBatchFault(faultDetail, true);
        }
        return responseInfo.getResponse();
    }

    private Exception getFaultException(ApplicationFault faultDetail) {
        try {
            Exception ex = this.processFaultDetail(faultDetail, false);
            if (ex == null) {
                ex = this.processFaultDetailApiBatchFault(faultDetail, false);
            }
            return ex;
        }
        catch (Exception ex) {
            throw new InternalException(ex);
        }
    }

    protected <Req, Resp> Response<Resp> sendRequestAsync(Req request, String entityEndpoint, String verb, Class<Resp> respClass, BiFunction<Req, AsyncHandler<Resp>, Future<?>> soapMethod, AsyncHandler<Resp> handler) {
        return this.processRequestAsync(request, entityEndpoint, verb, respClass, ApplicationFault.class, x -> this.getFaultException((ApplicationFault)x), soapMethod, handler);
    }

    @Override
    public GetBillingDocumentsInfoResponse getBillingDocumentsInfo(GetBillingDocumentsInfoRequest request) throws AdApiFaultDetail_Exception, ApiBatchFault_Exception, ApiFault_Exception {
        GetBillingDocumentsInfoResponse response = this.sendRequestApiBatchFault(request, "/BillingDocumentsInfo/Query", "POST", GetBillingDocumentsInfoResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getBillingDocumentsInfo(request);
        }
        return response;
    }

    @Override
    public Response<GetBillingDocumentsInfoResponse> getBillingDocumentsInfoAsync(GetBillingDocumentsInfoRequest request) {
        return this.sendRequestAsync(request, "/BillingDocumentsInfo/Query", "POST", GetBillingDocumentsInfoResponse.class, (r, h) -> this.fallbackService.get().getBillingDocumentsInfoAsync((GetBillingDocumentsInfoRequest)r, (AsyncHandler<GetBillingDocumentsInfoResponse>)h), null);
    }

    @Override
    public Future<?> getBillingDocumentsInfoAsync(GetBillingDocumentsInfoRequest request, AsyncHandler<GetBillingDocumentsInfoResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/BillingDocumentsInfo/Query", "POST", GetBillingDocumentsInfoResponse.class, (r, h) -> this.fallbackService.get().getBillingDocumentsInfoAsync((GetBillingDocumentsInfoRequest)r, (AsyncHandler<GetBillingDocumentsInfoResponse>)h), asyncHandler);
    }

    @Override
    public GetBillingDocumentsResponse getBillingDocuments(GetBillingDocumentsRequest request) throws AdApiFaultDetail_Exception, ApiBatchFault_Exception, ApiFault_Exception {
        GetBillingDocumentsResponse response = this.sendRequestApiBatchFault(request, "/BillingDocuments/Query", "POST", GetBillingDocumentsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getBillingDocuments(request);
        }
        return response;
    }

    @Override
    public Response<GetBillingDocumentsResponse> getBillingDocumentsAsync(GetBillingDocumentsRequest request) {
        return this.sendRequestAsync(request, "/BillingDocuments/Query", "POST", GetBillingDocumentsResponse.class, (r, h) -> this.fallbackService.get().getBillingDocumentsAsync((GetBillingDocumentsRequest)r, (AsyncHandler<GetBillingDocumentsResponse>)h), null);
    }

    @Override
    public Future<?> getBillingDocumentsAsync(GetBillingDocumentsRequest request, AsyncHandler<GetBillingDocumentsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/BillingDocuments/Query", "POST", GetBillingDocumentsResponse.class, (r, h) -> this.fallbackService.get().getBillingDocumentsAsync((GetBillingDocumentsRequest)r, (AsyncHandler<GetBillingDocumentsResponse>)h), asyncHandler);
    }

    @Override
    public AddInsertionOrderResponse addInsertionOrder(AddInsertionOrderRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        AddInsertionOrderResponse response = this.sendRequest(request, "/InsertionOrder", "POST", AddInsertionOrderResponse.class);
        if (response == null) {
            response = this.fallbackService.get().addInsertionOrder(request);
        }
        return response;
    }

    @Override
    public Response<AddInsertionOrderResponse> addInsertionOrderAsync(AddInsertionOrderRequest request) {
        return this.sendRequestAsync(request, "/InsertionOrder", "POST", AddInsertionOrderResponse.class, (r, h) -> this.fallbackService.get().addInsertionOrderAsync((AddInsertionOrderRequest)r, (AsyncHandler<AddInsertionOrderResponse>)h), null);
    }

    @Override
    public Future<?> addInsertionOrderAsync(AddInsertionOrderRequest request, AsyncHandler<AddInsertionOrderResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/InsertionOrder", "POST", AddInsertionOrderResponse.class, (r, h) -> this.fallbackService.get().addInsertionOrderAsync((AddInsertionOrderRequest)r, (AsyncHandler<AddInsertionOrderResponse>)h), asyncHandler);
    }

    @Override
    public UpdateInsertionOrderResponse updateInsertionOrder(UpdateInsertionOrderRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        UpdateInsertionOrderResponse response = this.sendRequest(request, "/InsertionOrder", "PUT", UpdateInsertionOrderResponse.class);
        if (response == null) {
            response = this.fallbackService.get().updateInsertionOrder(request);
        }
        return response;
    }

    @Override
    public Response<UpdateInsertionOrderResponse> updateInsertionOrderAsync(UpdateInsertionOrderRequest request) {
        return this.sendRequestAsync(request, "/InsertionOrder", "PUT", UpdateInsertionOrderResponse.class, (r, h) -> this.fallbackService.get().updateInsertionOrderAsync((UpdateInsertionOrderRequest)r, (AsyncHandler<UpdateInsertionOrderResponse>)h), null);
    }

    @Override
    public Future<?> updateInsertionOrderAsync(UpdateInsertionOrderRequest request, AsyncHandler<UpdateInsertionOrderResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/InsertionOrder", "PUT", UpdateInsertionOrderResponse.class, (r, h) -> this.fallbackService.get().updateInsertionOrderAsync((UpdateInsertionOrderRequest)r, (AsyncHandler<UpdateInsertionOrderResponse>)h), asyncHandler);
    }

    @Override
    public SearchInsertionOrdersResponse searchInsertionOrders(SearchInsertionOrdersRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        SearchInsertionOrdersResponse response = this.sendRequest(request, "/InsertionOrders/Search", "POST", SearchInsertionOrdersResponse.class);
        if (response == null) {
            response = this.fallbackService.get().searchInsertionOrders(request);
        }
        return response;
    }

    @Override
    public Response<SearchInsertionOrdersResponse> searchInsertionOrdersAsync(SearchInsertionOrdersRequest request) {
        return this.sendRequestAsync(request, "/InsertionOrders/Search", "POST", SearchInsertionOrdersResponse.class, (r, h) -> this.fallbackService.get().searchInsertionOrdersAsync((SearchInsertionOrdersRequest)r, (AsyncHandler<SearchInsertionOrdersResponse>)h), null);
    }

    @Override
    public Future<?> searchInsertionOrdersAsync(SearchInsertionOrdersRequest request, AsyncHandler<SearchInsertionOrdersResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/InsertionOrders/Search", "POST", SearchInsertionOrdersResponse.class, (r, h) -> this.fallbackService.get().searchInsertionOrdersAsync((SearchInsertionOrdersRequest)r, (AsyncHandler<SearchInsertionOrdersResponse>)h), asyncHandler);
    }

    @Override
    public GetAccountMonthlySpendResponse getAccountMonthlySpend(GetAccountMonthlySpendRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        GetAccountMonthlySpendResponse response = this.sendRequest(request, "/AccountMonthlySpend/Query", "POST", GetAccountMonthlySpendResponse.class);
        if (response == null) {
            response = this.fallbackService.get().getAccountMonthlySpend(request);
        }
        return response;
    }

    @Override
    public Response<GetAccountMonthlySpendResponse> getAccountMonthlySpendAsync(GetAccountMonthlySpendRequest request) {
        return this.sendRequestAsync(request, "/AccountMonthlySpend/Query", "POST", GetAccountMonthlySpendResponse.class, (r, h) -> this.fallbackService.get().getAccountMonthlySpendAsync((GetAccountMonthlySpendRequest)r, (AsyncHandler<GetAccountMonthlySpendResponse>)h), null);
    }

    @Override
    public Future<?> getAccountMonthlySpendAsync(GetAccountMonthlySpendRequest request, AsyncHandler<GetAccountMonthlySpendResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/AccountMonthlySpend/Query", "POST", GetAccountMonthlySpendResponse.class, (r, h) -> this.fallbackService.get().getAccountMonthlySpendAsync((GetAccountMonthlySpendRequest)r, (AsyncHandler<GetAccountMonthlySpendResponse>)h), asyncHandler);
    }

    @Override
    public DispatchCouponsResponse dispatchCoupons(DispatchCouponsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        DispatchCouponsResponse response = this.sendRequest(request, "/Coupons/Dispatch", "POST", DispatchCouponsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().dispatchCoupons(request);
        }
        return response;
    }

    @Override
    public Response<DispatchCouponsResponse> dispatchCouponsAsync(DispatchCouponsRequest request) {
        return this.sendRequestAsync(request, "/Coupons/Dispatch", "POST", DispatchCouponsResponse.class, (r, h) -> this.fallbackService.get().dispatchCouponsAsync((DispatchCouponsRequest)r, (AsyncHandler<DispatchCouponsResponse>)h), null);
    }

    @Override
    public Future<?> dispatchCouponsAsync(DispatchCouponsRequest request, AsyncHandler<DispatchCouponsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Coupons/Dispatch", "POST", DispatchCouponsResponse.class, (r, h) -> this.fallbackService.get().dispatchCouponsAsync((DispatchCouponsRequest)r, (AsyncHandler<DispatchCouponsResponse>)h), asyncHandler);
    }

    @Override
    public RedeemCouponResponse redeemCoupon(RedeemCouponRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        RedeemCouponResponse response = this.sendRequest(request, "/Coupon/Redeem", "POST", RedeemCouponResponse.class);
        if (response == null) {
            response = this.fallbackService.get().redeemCoupon(request);
        }
        return response;
    }

    @Override
    public Response<RedeemCouponResponse> redeemCouponAsync(RedeemCouponRequest request) {
        return this.sendRequestAsync(request, "/Coupon/Redeem", "POST", RedeemCouponResponse.class, (r, h) -> this.fallbackService.get().redeemCouponAsync((RedeemCouponRequest)r, (AsyncHandler<RedeemCouponResponse>)h), null);
    }

    @Override
    public Future<?> redeemCouponAsync(RedeemCouponRequest request, AsyncHandler<RedeemCouponResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Coupon/Redeem", "POST", RedeemCouponResponse.class, (r, h) -> this.fallbackService.get().redeemCouponAsync((RedeemCouponRequest)r, (AsyncHandler<RedeemCouponResponse>)h), asyncHandler);
    }

    @Override
    public SearchCouponsResponse searchCoupons(SearchCouponsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        SearchCouponsResponse response = this.sendRequest(request, "/Coupons/Search", "POST", SearchCouponsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().searchCoupons(request);
        }
        return response;
    }

    @Override
    public Response<SearchCouponsResponse> searchCouponsAsync(SearchCouponsRequest request) {
        return this.sendRequestAsync(request, "/Coupons/Search", "POST", SearchCouponsResponse.class, (r, h) -> this.fallbackService.get().searchCouponsAsync((SearchCouponsRequest)r, (AsyncHandler<SearchCouponsResponse>)h), null);
    }

    @Override
    public Future<?> searchCouponsAsync(SearchCouponsRequest request, AsyncHandler<SearchCouponsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/Coupons/Search", "POST", SearchCouponsResponse.class, (r, h) -> this.fallbackService.get().searchCouponsAsync((SearchCouponsRequest)r, (AsyncHandler<SearchCouponsResponse>)h), asyncHandler);
    }

    @Override
    public CheckFeatureAdoptionCouponEligibilityResponse checkFeatureAdoptionCouponEligibility(CheckFeatureAdoptionCouponEligibilityRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        CheckFeatureAdoptionCouponEligibilityResponse response = this.sendRequest(request, "/FeatureAdoptionCouponEligibility/Check", "POST", CheckFeatureAdoptionCouponEligibilityResponse.class);
        if (response == null) {
            response = this.fallbackService.get().checkFeatureAdoptionCouponEligibility(request);
        }
        return response;
    }

    @Override
    public Response<CheckFeatureAdoptionCouponEligibilityResponse> checkFeatureAdoptionCouponEligibilityAsync(CheckFeatureAdoptionCouponEligibilityRequest request) {
        return this.sendRequestAsync(request, "/FeatureAdoptionCouponEligibility/Check", "POST", CheckFeatureAdoptionCouponEligibilityResponse.class, (r, h) -> this.fallbackService.get().checkFeatureAdoptionCouponEligibilityAsync((CheckFeatureAdoptionCouponEligibilityRequest)r, (AsyncHandler<CheckFeatureAdoptionCouponEligibilityResponse>)h), null);
    }

    @Override
    public Future<?> checkFeatureAdoptionCouponEligibilityAsync(CheckFeatureAdoptionCouponEligibilityRequest request, AsyncHandler<CheckFeatureAdoptionCouponEligibilityResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/FeatureAdoptionCouponEligibility/Check", "POST", CheckFeatureAdoptionCouponEligibilityResponse.class, (r, h) -> this.fallbackService.get().checkFeatureAdoptionCouponEligibilityAsync((CheckFeatureAdoptionCouponEligibilityRequest)r, (AsyncHandler<CheckFeatureAdoptionCouponEligibilityResponse>)h), asyncHandler);
    }

    @Override
    public ClaimFeatureAdoptionCouponsResponse claimFeatureAdoptionCoupons(ClaimFeatureAdoptionCouponsRequest request) throws AdApiFaultDetail_Exception, ApiFault_Exception {
        ClaimFeatureAdoptionCouponsResponse response = this.sendRequest(request, "/FeatureAdoptionCoupons/Claim", "POST", ClaimFeatureAdoptionCouponsResponse.class);
        if (response == null) {
            response = this.fallbackService.get().claimFeatureAdoptionCoupons(request);
        }
        return response;
    }

    @Override
    public Response<ClaimFeatureAdoptionCouponsResponse> claimFeatureAdoptionCouponsAsync(ClaimFeatureAdoptionCouponsRequest request) {
        return this.sendRequestAsync(request, "/FeatureAdoptionCoupons/Claim", "POST", ClaimFeatureAdoptionCouponsResponse.class, (r, h) -> this.fallbackService.get().claimFeatureAdoptionCouponsAsync((ClaimFeatureAdoptionCouponsRequest)r, (AsyncHandler<ClaimFeatureAdoptionCouponsResponse>)h), null);
    }

    @Override
    public Future<?> claimFeatureAdoptionCouponsAsync(ClaimFeatureAdoptionCouponsRequest request, AsyncHandler<ClaimFeatureAdoptionCouponsResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/FeatureAdoptionCoupons/Claim", "POST", ClaimFeatureAdoptionCouponsResponse.class, (r, h) -> this.fallbackService.get().claimFeatureAdoptionCouponsAsync((ClaimFeatureAdoptionCouponsRequest)r, (AsyncHandler<ClaimFeatureAdoptionCouponsResponse>)h), asyncHandler);
    }
}

