/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal.restful;

import com.microsoft.bingads.ApiEnvironment;
import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.internal.restful.ResponseInfo;
import com.microsoft.bingads.internal.restful.RestfulServiceClient;
import com.microsoft.bingads.v13.reporting.AdApiFaultDetail;
import com.microsoft.bingads.v13.reporting.AdApiFaultDetail_Exception;
import com.microsoft.bingads.v13.reporting.ApiFaultDetail;
import com.microsoft.bingads.v13.reporting.ApiFaultDetail_Exception;
import com.microsoft.bingads.v13.reporting.ApplicationFault;
import com.microsoft.bingads.v13.reporting.IReportingService;
import com.microsoft.bingads.v13.reporting.PollGenerateReportRequest;
import com.microsoft.bingads.v13.reporting.PollGenerateReportResponse;
import com.microsoft.bingads.v13.reporting.SubmitGenerateReportRequest;
import com.microsoft.bingads.v13.reporting.SubmitGenerateReportResponse;
import jakarta.xml.ws.AsyncHandler;
import jakarta.xml.ws.Response;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class ReportingService
extends RestfulServiceClient
implements IReportingService {
    private Supplier<IReportingService> fallbackService;

    public ReportingService(Map<String, String> headers, ApiEnvironment env, Supplier<IReportingService> fallbackService) {
        super(headers, env, IReportingService.class);
        this.fallbackService = fallbackService;
    }

    Exception processFaultDetail(ApplicationFault faultDetail, boolean shouldThrow) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        String message = this.getFaultMessage(faultDetail.getTrackingId());
        if (faultDetail instanceof AdApiFaultDetail) {
            AdApiFaultDetail_Exception ex = new AdApiFaultDetail_Exception(message, (AdApiFaultDetail)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (faultDetail instanceof ApiFaultDetail) {
            ApiFaultDetail_Exception ex = new ApiFaultDetail_Exception(message, (ApiFaultDetail)faultDetail);
            if (shouldThrow) {
                throw ex;
            }
            return ex;
        }
        if (shouldThrow) {
            throw new RuntimeException("Unknown fault type: " + faultDetail.getClass());
        }
        return null;
    }

    protected <Req, Resp> Resp sendRequest(Req request, String entityEndpoint, String verb, Class<Resp> respClass) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        ResponseInfo<Resp, ApplicationFault> responseInfo = this.getResponseInfo(request, entityEndpoint, verb, respClass, ApplicationFault.class);
        if (responseInfo == null) {
            return null;
        }
        ApplicationFault faultDetail = responseInfo.getFaultDetail();
        if (faultDetail != null) {
            this.processFaultDetail(faultDetail, true);
        }
        return responseInfo.getResponse();
    }

    private Exception getFaultException(ApplicationFault faultDetail) {
        try {
            Exception ex = this.processFaultDetail(faultDetail, false);
            return ex;
        }
        catch (Exception ex) {
            throw new InternalException(ex);
        }
    }

    protected <Req, Resp> Response<Resp> sendRequestAsync(Req request, String entityEndpoint, String verb, Class<Resp> respClass, BiFunction<Req, AsyncHandler<Resp>, Future<?>> soapMethod, AsyncHandler<Resp> handler) {
        return this.processRequestAsync(request, entityEndpoint, verb, respClass, ApplicationFault.class, x -> this.getFaultException((ApplicationFault)x), soapMethod, handler);
    }

    @Override
    public SubmitGenerateReportResponse submitGenerateReport(SubmitGenerateReportRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        SubmitGenerateReportResponse response = this.sendRequest(request, "/GenerateReport/Submit", "POST", SubmitGenerateReportResponse.class);
        if (response == null) {
            response = this.fallbackService.get().submitGenerateReport(request);
        }
        return response;
    }

    @Override
    public Response<SubmitGenerateReportResponse> submitGenerateReportAsync(SubmitGenerateReportRequest request) {
        return this.sendRequestAsync(request, "/GenerateReport/Submit", "POST", SubmitGenerateReportResponse.class, (r, h) -> this.fallbackService.get().submitGenerateReportAsync((SubmitGenerateReportRequest)r, (AsyncHandler<SubmitGenerateReportResponse>)h), null);
    }

    @Override
    public Future<?> submitGenerateReportAsync(SubmitGenerateReportRequest request, AsyncHandler<SubmitGenerateReportResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/GenerateReport/Submit", "POST", SubmitGenerateReportResponse.class, (r, h) -> this.fallbackService.get().submitGenerateReportAsync((SubmitGenerateReportRequest)r, (AsyncHandler<SubmitGenerateReportResponse>)h), asyncHandler);
    }

    @Override
    public PollGenerateReportResponse pollGenerateReport(PollGenerateReportRequest request) throws AdApiFaultDetail_Exception, ApiFaultDetail_Exception {
        PollGenerateReportResponse response = this.sendRequest(request, "/GenerateReport/Poll", "POST", PollGenerateReportResponse.class);
        if (response == null) {
            response = this.fallbackService.get().pollGenerateReport(request);
        }
        return response;
    }

    @Override
    public Response<PollGenerateReportResponse> pollGenerateReportAsync(PollGenerateReportRequest request) {
        return this.sendRequestAsync(request, "/GenerateReport/Poll", "POST", PollGenerateReportResponse.class, (r, h) -> this.fallbackService.get().pollGenerateReportAsync((PollGenerateReportRequest)r, (AsyncHandler<PollGenerateReportResponse>)h), null);
    }

    @Override
    public Future<?> pollGenerateReportAsync(PollGenerateReportRequest request, AsyncHandler<PollGenerateReportResponse> asyncHandler) {
        return this.sendRequestAsync(request, "/GenerateReport/Poll", "POST", PollGenerateReportResponse.class, (r, h) -> this.fallbackService.get().pollGenerateReportAsync((PollGenerateReportRequest)r, (AsyncHandler<PollGenerateReportResponse>)h), asyncHandler);
    }
}

