/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAudience;
import com.microsoft.bingads.v13.campaignmanagement.CombinedList;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCombinedList
extends BulkAudience<CombinedList> {
    private static final List<BulkMapping<BulkCombinedList>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public CombinedList getCombinedList() {
        return (CombinedList)this.getAudience();
    }

    public void setCombinedList(CombinedList combinedList) {
        this.setAudience(combinedList);
    }

    @Override
    public CombinedList createAudience() {
        return new CombinedList();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCombinedList, String>> m = new ArrayList<SimpleBulkMapping<BulkCombinedList, String>>();
        m.add(new SimpleBulkMapping<BulkCombinedList, String>("Combination Rule", new Function<BulkCombinedList, String>(){

            @Override
            public String apply(BulkCombinedList c) {
                return StringExtensions.writeCombinationRulesBulkString(c.getCombinedList().getCombinationRules());
            }
        }, new BiConsumer<String, BulkCombinedList>(){

            @Override
            public void accept(String v, BulkCombinedList c) {
                c.getCombinedList().setCombinationRules(StringExtensions.parseCombinationRules(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

