package com.microsoft.bingads.internal.restful.adaptor.generated.campaignmanagement.enums;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.microsoft.bingads.v13.campaignmanagement.AssetGroupAdditionalField;
import com.microsoft.bingads.internal.restful.adaptor.AdaptorUtil;

public class AssetGroupAdditionalFieldDeserializer extends JsonDeserializer<Collection<AssetGroupAdditionalField>> {
	@Override
	public Collection<AssetGroupAdditionalField> deserialize(JsonParser p, DeserializationContext ctxt)
			throws IOException, JsonProcessingException {
		String s = p.getValueAsString();
		String[] strs = s.split(",");
		Collection<AssetGroupAdditionalField> res = new ArrayList<AssetGroupAdditionalField>();
		for (String str : strs)
		{
			res.add(Enum.valueOf(AssetGroupAdditionalField.class, AdaptorUtil.convertStringToEnumValue(str.trim())));
		}
		return res;
	}
}
