/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.AdExtensionEditorialStatus;
import com.microsoft.bingads.v13.campaignmanagement.AdExtensionIdToEntityIdAssociation;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkAdExtensionAssociation
extends SingleRecordBulkEntity {
    private Status status;
    private AdExtensionIdToEntityIdAssociation adExtensionIdToEntityIdAssociation;
    private AdExtensionEditorialStatus editorialStatus;
    private static final List<BulkMapping<BulkAdExtensionAssociation>> MAPPINGS;

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getAdExtensionIdToEntityIdAssociation(), "AdExtensionIdToEntityIdAssociation");
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        this.setAdExtensionIdToEntityIdAssociation(new AdExtensionIdToEntityIdAssociation());
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public AdExtensionEditorialStatus getEditorialStatus() {
        return this.editorialStatus;
    }

    void setEditorialStatus(AdExtensionEditorialStatus editorialStatus) {
        this.editorialStatus = editorialStatus;
    }

    public AdExtensionIdToEntityIdAssociation getAdExtensionIdToEntityIdAssociation() {
        return this.adExtensionIdToEntityIdAssociation;
    }

    public void setAdExtensionIdToEntityIdAssociation(AdExtensionIdToEntityIdAssociation adExtensionIdToEntityIdAssociation) {
        this.adExtensionIdToEntityIdAssociation = adExtensionIdToEntityIdAssociation;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdExtensionAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdExtensionAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkAdExtensionAssociation, String>("Status", new Function<BulkAdExtensionAssociation, String>(){

            @Override
            public String apply(BulkAdExtensionAssociation c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAdExtensionAssociation>(){

            @Override
            public void accept(String v, BulkAdExtensionAssociation c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return StringExtensions.fromValueOptional(value, Status.class);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtensionAssociation, Long>("Id", new Function<BulkAdExtensionAssociation, Long>(){

            @Override
            public Long apply(BulkAdExtensionAssociation c) {
                return c.getAdExtensionIdToEntityIdAssociation().getAdExtensionId();
            }
        }, new BiConsumer<String, BulkAdExtensionAssociation>(){

            @Override
            public void accept(String v, BulkAdExtensionAssociation c) {
                c.getAdExtensionIdToEntityIdAssociation().setAdExtensionId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtensionAssociation, Long>("Parent Id", new Function<BulkAdExtensionAssociation, Long>(){

            @Override
            public Long apply(BulkAdExtensionAssociation c) {
                return c.getAdExtensionIdToEntityIdAssociation().getEntityId();
            }
        }, new BiConsumer<String, BulkAdExtensionAssociation>(){

            @Override
            public void accept(String v, BulkAdExtensionAssociation c) {
                c.getAdExtensionIdToEntityIdAssociation().setEntityId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdExtensionAssociation, String>("Editorial Status", new Function<BulkAdExtensionAssociation, String>(){

            @Override
            public String apply(BulkAdExtensionAssociation t) {
                return t.getEditorialStatus() != null ? t.getEditorialStatus().value() : null;
            }
        }, new BiConsumer<String, BulkAdExtensionAssociation>(){

            @Override
            public void accept(String v, BulkAdExtensionAssociation c) {
                c.setEditorialStatus(StringExtensions.parseOptional(v, new Function<String, AdExtensionEditorialStatus>(){

                    @Override
                    public AdExtensionEditorialStatus apply(String value) {
                        return StringExtensions.fromValueOptional(value, AdExtensionEditorialStatus.class);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

