/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkConversionGoal;
import com.microsoft.bingads.v13.campaignmanagement.DurationGoal;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkDurationGoal
extends BulkConversionGoal<DurationGoal> {
    private static final List<BulkMapping<BulkDurationGoal>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public DurationGoal getDurationGoal() {
        return (DurationGoal)this.getConversionGoal();
    }

    public void setDurationGoal(DurationGoal DurationGoal2) {
        this.setConversionGoal(DurationGoal2);
    }

    @Override
    public DurationGoal createConversionGoal() {
        return new DurationGoal();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkDurationGoal, Integer>> m = new ArrayList<SimpleBulkMapping<BulkDurationGoal, Integer>>();
        m.add(new SimpleBulkMapping<BulkDurationGoal, Integer>("Minimum Duration In Second", new Function<BulkDurationGoal, Integer>(){

            @Override
            public Integer apply(BulkDurationGoal c) {
                return ((DurationGoal)c.getConversionGoal()).getMinimumDurationInSeconds();
            }
        }, new BiConsumer<String, BulkDurationGoal>(){

            @Override
            public void accept(String v, BulkDurationGoal c) {
                ((DurationGoal)c.getConversionGoal()).setMinimumDurationInSeconds(StringExtensions.parseOptional(v, new Function<String, Integer>(){

                    @Override
                    public Integer apply(String value) {
                        return Integer.parseInt(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

