/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.microsoft.bot.builder.BotState;
import com.microsoft.bot.builder.BotStateSet;
import com.microsoft.bot.builder.Middleware;
import com.microsoft.bot.builder.NextDelegate;
import com.microsoft.bot.builder.TurnContext;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;

public class AutoSaveStateMiddleware
implements Middleware {
    private BotStateSet botStateSet;

    public AutoSaveStateMiddleware(BotState ... botStates) {
        this.botStateSet = new BotStateSet(Arrays.asList(botStates));
    }

    public AutoSaveStateMiddleware(BotStateSet withBotStateSet) {
        this.botStateSet = withBotStateSet;
    }

    public BotStateSet getBotStateSet() {
        return this.botStateSet;
    }

    public void setBotStateSet(BotStateSet withBotStateSet) {
        this.botStateSet = withBotStateSet;
    }

    public AutoSaveStateMiddleware add(BotState botState) {
        if (botState == null) {
            throw new IllegalArgumentException("botState cannot be null");
        }
        this.botStateSet.add(botState);
        return this;
    }

    @Override
    public CompletableFuture<Void> onTurn(TurnContext turnContext, NextDelegate next) {
        return next.next().thenCompose(result -> this.botStateSet.saveAllChanges(turnContext));
    }
}

