/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.bot.builder.PropertyManager;
import com.microsoft.bot.builder.StatePropertyAccessor;
import com.microsoft.bot.builder.Storage;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.connector.Async;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public abstract class BotState
implements PropertyManager {
    private String contextServiceKey;
    private Storage storage;
    private ObjectMapper mapper = new ObjectMapper().findAndRegisterModules();

    public BotState(Storage withStorage, String withContextServiceKey) throws IllegalArgumentException {
        if (withStorage == null) {
            throw new IllegalArgumentException("Storage cannot be null");
        }
        this.storage = withStorage;
        if (StringUtils.isEmpty((CharSequence)withContextServiceKey)) {
            throw new IllegalArgumentException("context service key cannot be empty");
        }
        this.contextServiceKey = withContextServiceKey;
    }

    @Override
    public <T> StatePropertyAccessor<T> createProperty(String name) throws IllegalArgumentException {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        return new BotStatePropertyAccessor(this, name);
    }

    public CompletableFuture<Void> load(TurnContext turnContext) {
        return this.load(turnContext, false);
    }

    public CompletableFuture<Void> load(TurnContext turnContext, boolean force) {
        return Async.tryCompletable(() -> {
            if (turnContext == null) {
                throw new IllegalArgumentException("turnContext cannot be null");
            }
            CachedBotState cachedState = (CachedBotState)turnContext.getTurnState().get(this.contextServiceKey);
            String storageKey = this.getStorageKey(turnContext);
            if (force || cachedState == null || cachedState.getState() == null) {
                return this.storage.read(new String[]{storageKey}).thenApply(val -> {
                    turnContext.getTurnState().replace(this.contextServiceKey, new CachedBotState((Map)val.get(storageKey)));
                    return null;
                });
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public CompletableFuture<Void> saveChanges(TurnContext turnContext) {
        return this.saveChanges(turnContext, false);
    }

    public CompletableFuture<Void> saveChanges(TurnContext turnContext, boolean force) {
        return Async.tryCompletable(() -> {
            if (turnContext == null) {
                throw new IllegalArgumentException("turnContext cannot be null");
            }
            CachedBotState cachedState = (CachedBotState)turnContext.getTurnState().get(this.contextServiceKey);
            if (force || cachedState != null && cachedState.isChanged()) {
                String storageKey = this.getStorageKey(turnContext);
                HashMap<String, Object> changes = new HashMap<String, Object>();
                changes.put(storageKey, cachedState.state);
                return this.storage.write(changes).thenApply(val -> {
                    cachedState.setHash(cachedState.computeHash(cachedState.state));
                    return null;
                });
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    public CompletableFuture<Void> clearState(TurnContext turnContext) {
        if (turnContext == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext cannot be null."));
        }
        turnContext.getTurnState().replace(this.contextServiceKey, new CachedBotState());
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> delete(TurnContext turnContext) {
        if (turnContext == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext cannot be null."));
        }
        String storageKey = this.getStorageKey(turnContext);
        return this.storage.delete(new String[]{storageKey}).thenApply(result -> {
            CachedBotState cachedState = (CachedBotState)turnContext.getTurnState().get(this.contextServiceKey);
            if (cachedState != null) {
                turnContext.getTurnState().remove(this.contextServiceKey);
            }
            return null;
        });
    }

    public JsonNode get(TurnContext turnContext) {
        if (turnContext == null) {
            throw new IllegalArgumentException("turnContext cannot be null");
        }
        String stateKey = this.getClass().getSimpleName();
        CachedBotState cachedState = (CachedBotState)turnContext.getTurnState().get(stateKey);
        return this.mapper.valueToTree((Object)cachedState.state);
    }

    public CachedBotState getCachedState(TurnContext turnContext) {
        if (turnContext == null) {
            throw new IllegalArgumentException("turnContext cannot be null");
        }
        return (CachedBotState)turnContext.getTurnState().get(this.contextServiceKey);
    }

    public abstract String getStorageKey(TurnContext var1) throws IllegalArgumentException;

    protected <T> CompletableFuture<T> getPropertyValue(TurnContext turnContext, String propertyName) {
        if (turnContext == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("turnContext cannot be null"));
        }
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("propertyName cannot be empty"));
        }
        return Async.tryCompletable(() -> {
            CachedBotState cachedState = (CachedBotState)turnContext.getTurnState().get(this.contextServiceKey);
            return CompletableFuture.completedFuture(cachedState.getState().get(propertyName));
        });
    }

    protected CompletableFuture<Void> deletePropertyValue(TurnContext turnContext, String propertyName) {
        if (turnContext == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("TurnContext cannot be null."));
        }
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("propertyName cannot be empty"));
        }
        CachedBotState cachedState = (CachedBotState)turnContext.getTurnState().get(this.contextServiceKey);
        cachedState.getState().remove(propertyName);
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> setPropertyValue(TurnContext turnContext, String propertyName, Object value) {
        if (turnContext == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("turnContext cannot be null."));
        }
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("propertyName cannot be empty"));
        }
        CachedBotState cachedState = (CachedBotState)turnContext.getTurnState().get(this.contextServiceKey);
        cachedState.getState().put(propertyName, value);
        return CompletableFuture.completedFuture(null);
    }

    private static class BotStatePropertyAccessor<T>
    implements StatePropertyAccessor<T> {
        private String name;
        private BotState botState;

        BotStatePropertyAccessor(BotState withState, String withName) {
            this.botState = withState;
            this.name = withName;
        }

        @Override
        public CompletableFuture<T> get(TurnContext turnContext, Supplier<T> defaultValueFactory) {
            return this.botState.load(turnContext).thenCombine((CompletionStage)this.botState.getPropertyValue(turnContext, this.name), (loadResult, value) -> {
                if (value != null) {
                    return value;
                }
                if (defaultValueFactory == null) {
                    return null;
                }
                value = defaultValueFactory.get();
                this.set(turnContext, value).join();
                return value;
            });
        }

        @Override
        public CompletableFuture<Void> delete(TurnContext turnContext) {
            return this.botState.load(turnContext).thenCompose(state -> this.botState.deletePropertyValue(turnContext, this.name));
        }

        @Override
        public CompletableFuture<Void> set(TurnContext turnContext, T value) {
            return this.botState.load(turnContext).thenCompose(state -> this.botState.setPropertyValue(turnContext, this.name, value));
        }

        @Override
        public String getName() {
            return this.name;
        }

        public void setName(String withName) {
            this.name = withName;
        }
    }

    public static class CachedBotState {
        private Map<String, Object> state;
        private String hash;
        private ObjectMapper mapper = new ObjectMapper().findAndRegisterModules();

        CachedBotState() {
            this(null);
        }

        CachedBotState(Map<String, Object> withState) {
            this.state = withState != null ? withState : new ConcurrentHashMap();
            this.hash = this.computeHash(withState);
        }

        public Map<String, Object> getState() {
            return this.state;
        }

        void setState(Map<String, Object> withState) {
            this.state = withState;
        }

        String getHash() {
            return this.hash;
        }

        void setHash(String witHashCode) {
            this.hash = witHashCode;
        }

        boolean isChanged() {
            return !StringUtils.equals((CharSequence)this.hash, (CharSequence)this.computeHash(this.state));
        }

        String computeHash(Object obj) {
            if (obj == null) {
                return "";
            }
            try {
                return this.mapper.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                return null;
            }
        }
    }
}

