/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.authentication.AuthenticationConfiguration;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.ChannelProvider;
import com.microsoft.bot.connector.authentication.ClaimsIdentity;
import com.microsoft.bot.connector.authentication.CredentialProvider;
import com.microsoft.bot.connector.authentication.JwtTokenValidation;
import com.microsoft.bot.connector.authentication.SkillValidation;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.AttachmentData;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.ConversationParameters;
import com.microsoft.bot.schema.ConversationResourceResponse;
import com.microsoft.bot.schema.ConversationsResult;
import com.microsoft.bot.schema.PagedMembersResult;
import com.microsoft.bot.schema.ResourceResponse;
import com.microsoft.bot.schema.Transcript;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

public class ChannelServiceHandler {
    private ChannelProvider channelProvider;
    private final AuthenticationConfiguration authConfiguration;
    private final CredentialProvider credentialProvider;

    public ChannelServiceHandler(CredentialProvider credentialProvider, AuthenticationConfiguration authConfiguration, ChannelProvider channelProvider) {
        if (credentialProvider == null) {
            throw new IllegalArgumentException("credentialprovider cannot be null");
        }
        if (authConfiguration == null) {
            throw new IllegalArgumentException("authConfiguration cannot be null");
        }
        this.credentialProvider = credentialProvider;
        this.authConfiguration = authConfiguration;
        this.channelProvider = channelProvider;
    }

    public CompletableFuture<ResourceResponse> handleSendToConversation(String authHeader, String conversationId, Activity activity) {
        return this.authenticate(authHeader).thenCompose(claimsIdentity -> this.onSendToConversation((ClaimsIdentity)claimsIdentity, conversationId, activity));
    }

    public CompletableFuture<ResourceResponse> handleReplyToActivity(String authHeader, String conversationId, String activityId, Activity activity) {
        return this.authenticate(authHeader).thenCompose(claimsIdentity -> this.onReplyToActivity((ClaimsIdentity)claimsIdentity, conversationId, activityId, activity));
    }

    public CompletableFuture<ResourceResponse> handleUpdateActivity(String authHeader, String conversationId, String activityId, Activity activity) {
        return this.authenticate(authHeader).thenCompose(claimsIdentity -> this.onUpdateActivity((ClaimsIdentity)claimsIdentity, conversationId, activityId, activity));
    }

    public CompletableFuture<Void> handleDeleteActivity(String authHeader, String conversationId, String activityId) {
        return this.authenticate(authHeader).thenCompose(claimsIdentity -> this.onDeleteActivity((ClaimsIdentity)claimsIdentity, conversationId, activityId));
    }

    public CompletableFuture<List<ChannelAccount>> handleGetActivityMembers(String authHeader, String conversationId, String activityId) {
        return this.authenticate(authHeader).thenCompose(claimsIdentity -> this.onGetActivityMembers((ClaimsIdentity)claimsIdentity, conversationId, activityId));
    }

    public CompletableFuture<ConversationResourceResponse> handleCreateConversation(String authHeader, ConversationParameters parameters) {
        return this.authenticate(authHeader).thenCompose(claimsIdentity -> this.onCreateConversation((ClaimsIdentity)claimsIdentity, parameters));
    }

    public CompletableFuture<ConversationsResult> handleGetConversations(String authHeader, String conversationId, String continuationToken) {
        return this.authenticate(authHeader).thenCompose(claimsIdentity -> this.onGetConversations((ClaimsIdentity)claimsIdentity, conversationId, continuationToken));
    }

    public CompletableFuture<List<ChannelAccount>> handleGetConversationMembers(String authHeader, String conversationId) {
        return this.authenticate(authHeader).thenCompose(claimsIdentity -> this.onGetConversationMembers((ClaimsIdentity)claimsIdentity, conversationId));
    }

    public CompletableFuture<PagedMembersResult> handleGetConversationPagedMembers(String authHeader, String conversationId, Integer pageSize, String continuationToken) {
        return this.authenticate(authHeader).thenCompose(claimsIdentity -> this.onGetConversationPagedMembers((ClaimsIdentity)claimsIdentity, conversationId, pageSize, continuationToken));
    }

    public CompletableFuture<Void> handleDeleteConversationMember(String authHeader, String conversationId, String memberId) {
        return this.authenticate(authHeader).thenCompose(claimsIdentity -> this.onDeleteConversationMember((ClaimsIdentity)claimsIdentity, conversationId, memberId));
    }

    public CompletableFuture<ResourceResponse> handleSendConversationHistory(String authHeader, String conversationId, Transcript transcript) {
        return this.authenticate(authHeader).thenCompose(claimsIdentity -> this.onSendConversationHistory((ClaimsIdentity)claimsIdentity, conversationId, transcript));
    }

    public CompletableFuture<ResourceResponse> handleUploadAttachment(String authHeader, String conversationId, AttachmentData attachmentUpload) {
        return this.authenticate(authHeader).thenCompose(claimsIdentity -> this.onUploadAttachment((ClaimsIdentity)claimsIdentity, conversationId, attachmentUpload));
    }

    protected CompletableFuture<ResourceResponse> onSendToConversation(ClaimsIdentity claimsIdentity, String conversationId, Activity activity) {
        throw new NotImplementedException("onSendToConversation is not implemented");
    }

    protected CompletableFuture<ResourceResponse> onReplyToActivity(ClaimsIdentity claimsIdentity, String conversationId, String activityId, Activity activity) {
        throw new NotImplementedException("onReplyToActivity is not implemented");
    }

    protected CompletableFuture<ResourceResponse> onUpdateActivity(ClaimsIdentity claimsIdentity, String conversationId, String activityId, Activity activity) {
        throw new NotImplementedException("onUpdateActivity is not implemented");
    }

    protected CompletableFuture<Void> onDeleteActivity(ClaimsIdentity claimsIdentity, String conversationId, String activityId) {
        throw new NotImplementedException("onDeleteActivity is not implemented");
    }

    protected CompletableFuture<List<ChannelAccount>> onGetActivityMembers(ClaimsIdentity claimsIdentity, String conversationId, String activityId) {
        throw new NotImplementedException("onGetActivityMembers is not implemented");
    }

    protected CompletableFuture<ConversationResourceResponse> onCreateConversation(ClaimsIdentity claimsIdentity, ConversationParameters parameters) {
        throw new NotImplementedException("onCreateConversation is not implemented");
    }

    protected CompletableFuture<ConversationsResult> onGetConversations(ClaimsIdentity claimsIdentity, String conversationId, String continuationToken) {
        throw new NotImplementedException("onGetConversationMembers is not implemented");
    }

    protected CompletableFuture<List<ChannelAccount>> onGetConversationMembers(ClaimsIdentity claimsIdentity, String conversationId) {
        throw new NotImplementedException("onGetConversationMembers is not implemented");
    }

    protected CompletableFuture<PagedMembersResult> onGetConversationPagedMembers(ClaimsIdentity claimsIdentity, String conversationId, Integer pageSize, String continuationToken) {
        throw new NotImplementedException("onGetConversationPagedMembers is not implemented");
    }

    protected CompletableFuture<Void> onDeleteConversationMember(ClaimsIdentity claimsIdentity, String conversationId, String memberId) {
        throw new NotImplementedException("onDeleteConversationMember is not implemented");
    }

    protected CompletableFuture<ResourceResponse> onSendConversationHistory(ClaimsIdentity claimsIdentity, String conversationId, Transcript transcript) {
        throw new NotImplementedException("onSendConversationHistory is not implemented");
    }

    protected CompletableFuture<ResourceResponse> onUploadAttachment(ClaimsIdentity claimsIdentity, String conversationId, AttachmentData attachmentUpload) {
        throw new NotImplementedException("onUploadAttachment is not implemented");
    }

    private CompletableFuture<ClaimsIdentity> authenticate(String authHeader) {
        if (StringUtils.isEmpty((CharSequence)authHeader)) {
            return this.credentialProvider.isAuthenticationDisabled().thenCompose(isAuthDisabled -> {
                if (!isAuthDisabled.booleanValue()) {
                    return Async.completeExceptionally((Throwable)new AuthenticationException("No auth header, Auth is required. Request is not authorized"));
                }
                return CompletableFuture.completedFuture(SkillValidation.createAnonymousSkillClaim());
            });
        }
        return JwtTokenValidation.validateAuthHeader((String)authHeader, (CredentialProvider)this.credentialProvider, (ChannelProvider)this.getChannelProvider(), (String)"unknown", null, (AuthenticationConfiguration)this.authConfiguration);
    }

    protected ChannelProvider getChannelProvider() {
        return this.channelProvider;
    }
}

