/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.codepoetics.protonpack.StreamUtils;
import com.microsoft.bot.builder.PagedResult;
import com.microsoft.bot.builder.TranscriptInfo;
import com.microsoft.bot.builder.TranscriptStore;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.schema.Activity;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MemoryTranscriptStore
implements TranscriptStore {
    private static final int PAGE_SIZE = 20;
    private final Object sync = new Object();
    private HashMap<String, HashMap<String, ArrayList<Activity>>> channels = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CompletableFuture<Void> logActivity(Activity activity) {
        if (activity == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException("activity cannot be null for LogActivity()"));
        }
        Object object = this.sync;
        synchronized (object) {
            ArrayList transcript;
            HashMap<Object, Object> channel;
            if (!this.channels.containsKey(activity.getChannelId())) {
                channel = new HashMap();
                this.channels.put(activity.getChannelId(), channel);
            } else {
                channel = this.channels.get(activity.getChannelId());
            }
            if (!channel.containsKey(activity.getConversation().getId())) {
                transcript = new ArrayList();
                channel.put(activity.getConversation().getId(), transcript);
            } else {
                transcript = (ArrayList)channel.get(activity.getConversation().getId());
            }
            transcript.add(activity);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<PagedResult<Activity>> getTranscriptActivities(String channelId, String conversationId, String continuationToken, OffsetDateTime startDate) {
        if (channelId == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException(String.format("missing %1$s", "channelId")));
        }
        if (conversationId == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException(String.format("missing %1$s", "conversationId")));
        }
        PagedResult pagedResult = new PagedResult();
        Object object = this.sync;
        synchronized (object) {
            HashMap<String, ArrayList<Activity>> channel;
            if (this.channels.containsKey(channelId) && (channel = this.channels.get(channelId)).containsKey(conversationId)) {
                OffsetDateTime effectiveStartDate = startDate == null ? OffsetDateTime.MIN : startDate;
                ArrayList<Activity> transcript = channel.get(conversationId);
                Stream<Object> stream = transcript.stream().sorted(Comparator.comparing(Activity::getTimestamp)).filter(a -> a.getTimestamp().compareTo(effectiveStartDate) >= 0);
                if (continuationToken != null) {
                    stream = StreamUtils.skipWhile(stream, a -> !a.getId().equals(continuationToken)).skip(1L);
                }
                List items = stream.limit(20L).collect(Collectors.toList());
                pagedResult.setItems(items);
                if (pagedResult.getItems().size() == 20) {
                    pagedResult.setContinuationToken(((Activity)items.get(items.size() - 1)).getId());
                }
            }
        }
        return CompletableFuture.completedFuture(pagedResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> deleteTranscript(String channelId, String conversationId) {
        if (channelId == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException(String.format("%1$s should not be null", "channelId")));
        }
        if (conversationId == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException(String.format("%1$s should not be null", "conversationId")));
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.channels.containsKey(channelId)) {
                HashMap<String, ArrayList<Activity>> channel = this.channels.get(channelId);
                channel.remove(conversationId);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<PagedResult<TranscriptInfo>> listTranscripts(String channelId, String continuationToken) {
        if (channelId == null) {
            return Async.completeExceptionally((Throwable)new IllegalArgumentException(String.format("missing %1$s", "channelId")));
        }
        PagedResult pagedResult = new PagedResult();
        Object object = this.sync;
        synchronized (object) {
            if (this.channels.containsKey(channelId)) {
                HashMap<String, ArrayList<Activity>> channel = this.channels.get(channelId);
                Stream<TranscriptInfo> stream = channel.entrySet().stream().map(c -> {
                    OffsetDateTime offsetDateTime = ((ArrayList)c.getValue()).stream().findFirst().isPresent() ? ((Activity)((ArrayList)c.getValue()).stream().findFirst().get()).getTimestamp() : OffsetDateTime.now();
                    return new TranscriptInfo((String)c.getKey(), channelId, offsetDateTime);
                }).sorted(Comparator.comparing(TranscriptInfo::getCreated));
                if (continuationToken != null) {
                    stream = StreamUtils.skipWhile(stream, c -> !c.getId().equals(continuationToken)).skip(1L);
                }
                List items = stream.limit(20L).collect(Collectors.toList());
                pagedResult.setItems(items);
                if (items.size() == 20) {
                    pagedResult.setContinuationToken(((TranscriptInfo)items.get(items.size() - 1)).getId());
                }
            }
        }
        return CompletableFuture.completedFuture(pagedResult);
    }
}

