/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.microsoft.bot.schema.ActionTypes;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.Attachment;
import com.microsoft.bot.schema.AttachmentLayoutTypes;
import com.microsoft.bot.schema.CardAction;
import com.microsoft.bot.schema.InputHints;
import com.microsoft.bot.schema.SuggestedActions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class MessageFactory {
    private MessageFactory() {
    }

    public static Activity text(String text) {
        return MessageFactory.text(text, null, null);
    }

    public static Activity text(String text, String ssml, InputHints inputHint) {
        Activity activity = Activity.createMessageActivity();
        MessageFactory.setTextAndSpeech(activity, text, ssml, inputHint);
        return activity;
    }

    public static Activity suggestedActions(List<String> actions, String text) {
        return MessageFactory.suggestedActions(actions, text, null, null);
    }

    public static Activity suggestedActions(List<String> actions, String text, String ssml, InputHints inputHint) {
        if (actions == null) {
            throw new IllegalArgumentException("actions cannot be null");
        }
        ArrayList<CardAction> cardActions = new ArrayList<CardAction>();
        for (String action : actions) {
            CardAction cardAction = new CardAction();
            cardAction.setType(ActionTypes.IM_BACK);
            cardAction.setValue((Object)action);
            cardAction.setTitle(action);
            cardActions.add(cardAction);
        }
        return MessageFactory.suggestedCardActions(cardActions, text, ssml, inputHint);
    }

    public static Activity suggestedCardActions(List<CardAction> actions, String text) {
        return MessageFactory.suggestedCardActions(actions, text, null, null);
    }

    public static Activity suggestedCardActions(List<CardAction> actions, String text, String ssml, InputHints inputHint) {
        if (actions == null) {
            throw new IllegalArgumentException("actions cannot be null");
        }
        Activity activity = Activity.createMessageActivity();
        MessageFactory.setTextAndSpeech(activity, text, ssml, inputHint);
        activity.setSuggestedActions(new SuggestedActions(actions.toArray(new CardAction[0])));
        return activity;
    }

    public static Activity attachment(Attachment attachment) {
        return MessageFactory.attachment(attachment, null, null, null);
    }

    public static Activity attachment(List<Attachment> attachments) {
        return MessageFactory.attachment(attachments, null, null, null);
    }

    public static Activity attachment(Attachment attachment, String text) {
        return MessageFactory.attachment(attachment, text, null, null);
    }

    public static Activity attachment(Attachment attachment, String text, String ssml, InputHints inputHint) {
        if (attachment == null) {
            throw new IllegalArgumentException("attachment cannot be null");
        }
        return MessageFactory.attachment(Collections.singletonList(attachment), text, ssml, inputHint);
    }

    public static Activity attachment(List<Attachment> attachments, String text, String ssml, InputHints inputHint) {
        if (attachments == null) {
            throw new IllegalArgumentException("attachments cannot be null");
        }
        return MessageFactory.attachmentActivity(AttachmentLayoutTypes.LIST, attachments, text, ssml, inputHint);
    }

    public static Activity carousel(List<Attachment> attachments, String text) {
        return MessageFactory.carousel(attachments, text, null, null);
    }

    public static Activity carousel(List<Attachment> attachments, String text, String ssml, InputHints inputHint) {
        if (attachments == null) {
            throw new IllegalArgumentException("attachments cannot be null");
        }
        return MessageFactory.attachmentActivity(AttachmentLayoutTypes.CAROUSEL, attachments, text, ssml, inputHint);
    }

    public static Activity contentUrl(String url, String contentType) {
        return MessageFactory.contentUrl(url, contentType, null, null, null, null);
    }

    public static Activity contentUrl(String url, String contentType, String name, String text, String ssml, InputHints inputHint) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            throw new IllegalArgumentException("url cannot be null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("contentType cannot be null or empty");
        }
        Attachment attachment = new Attachment();
        attachment.setContentType(contentType);
        attachment.setContentUrl(url);
        attachment.setName(StringUtils.isEmpty((CharSequence)name) ? null : name);
        return MessageFactory.attachmentActivity(AttachmentLayoutTypes.LIST, Collections.singletonList(attachment), text, ssml, inputHint);
    }

    private static Activity attachmentActivity(AttachmentLayoutTypes attachmentLayout, List<Attachment> attachments, String text, String ssml, InputHints inputHint) {
        Activity activity = Activity.createMessageActivity();
        activity.setAttachmentLayout(attachmentLayout);
        activity.setAttachments(attachments);
        MessageFactory.setTextAndSpeech(activity, text, ssml, inputHint);
        return activity;
    }

    private static void setTextAndSpeech(Activity activity, String text, String ssml, InputHints inputHint) {
        activity.setText(StringUtils.isEmpty((CharSequence)text) ? null : text);
        activity.setSpeak(StringUtils.isEmpty((CharSequence)ssml) ? null : ssml);
        activity.setInputHint(inputHint == null ? InputHints.ACCEPTING_INPUT : inputHint);
    }
}

