/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.microsoft.bot.builder.Middleware;
import com.microsoft.bot.builder.NextDelegate;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.schema.Activity;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SetSpeakMiddleware
implements Middleware {
    private final String voiceName;
    private final boolean fallbackToTextForSpeak;

    public SetSpeakMiddleware(String voiceName, boolean fallbackToTextForSpeak) {
        this.voiceName = voiceName;
        this.fallbackToTextForSpeak = fallbackToTextForSpeak;
    }

    @Override
    public CompletableFuture<Void> onTurn(TurnContext turnContext, NextDelegate next) {
        turnContext.onSendActivities((ctx, activities, nextSend) -> {
            for (Activity activity : activities) {
                if (!activity.getType().equals("message")) continue;
                if (this.fallbackToTextForSpeak && StringUtils.isBlank((CharSequence)activity.getSpeak())) {
                    activity.setSpeak(activity.getText());
                }
                if (!StringUtils.isNotBlank((CharSequence)activity.getSpeak()) || !StringUtils.isNotBlank((CharSequence)this.voiceName) || StringUtils.compareIgnoreCase((String)turnContext.getActivity().getChannelId(), (String)"directlinespeech") != 0 && StringUtils.compareIgnoreCase((String)turnContext.getActivity().getChannelId(), (String)"emulator") != 0 && StringUtils.compareIgnoreCase((String)turnContext.getActivity().getChannelId(), (String)"telephony") != 0) continue;
                if (!this.hasTag("speak", activity.getSpeak()) && !this.hasTag("voice", activity.getSpeak())) {
                    activity.setSpeak(String.format("<voice name='%s'>%s</voice>", this.voiceName, activity.getSpeak()));
                }
                activity.setSpeak(String.format("<speak version='1.0' xmlns='http://www.w3.org/2001/10/synthesis' xml:lang='%s'>%s</speak>", activity.getLocale() != null ? activity.getLocale() : "en-US", activity.getSpeak()));
            }
            return (CompletableFuture)nextSend.get();
        });
        return next.next();
    }

    private boolean hasTag(String tagName, String speakText) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(speakText);
            return doc.getElementsByTagName(tagName).getLength() > 0;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            return false;
        }
    }
}

