/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.builder;

import com.microsoft.bot.builder.Middleware;
import com.microsoft.bot.builder.NextDelegate;
import com.microsoft.bot.builder.TranscriptLogger;
import com.microsoft.bot.builder.TurnContext;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.RoleTypes;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.StringUtils;

public class TranscriptLoggerMiddleware
implements Middleware {
    private TranscriptLogger transcriptLogger;
    private Queue<Activity> transcript = new ConcurrentLinkedQueue<Activity>();

    public TranscriptLoggerMiddleware(TranscriptLogger withTranscriptLogger) {
        if (withTranscriptLogger == null) {
            throw new IllegalArgumentException("TranscriptLoggerMiddleware requires a ITranscriptLogger implementation.");
        }
        this.transcriptLogger = withTranscriptLogger;
    }

    @Override
    public CompletableFuture<Void> onTurn(TurnContext context, NextDelegate next) {
        if (context.getActivity() != null) {
            if (context.getActivity().getFrom() == null) {
                context.getActivity().setFrom(new ChannelAccount());
            }
            if (context.getActivity().getFrom().getProperties().get("role") == null && context.getActivity().getFrom().getRole() == null) {
                context.getActivity().getFrom().setRole(RoleTypes.USER);
            }
            if (!context.getActivity().isType("event") || !StringUtils.equals((CharSequence)context.getActivity().getName(), (CharSequence)"ContinueConversation")) {
                this.logActivity(Activity.clone((Activity)context.getActivity()), true);
            }
        }
        context.onSendActivities((ctx, activities, nextSend) -> ((CompletableFuture)nextSend.get()).thenApply(responses -> {
            for (Activity activity : activities) {
                this.logActivity(Activity.clone((Activity)activity), false);
            }
            return responses;
        }));
        context.onUpdateActivity((ctx, activity, nextUpdate) -> ((CompletableFuture)nextUpdate.get()).thenApply(resourceResponse -> {
            Activity updateActivity = Activity.clone((Activity)activity);
            updateActivity.setType("messageUpdate");
            this.logActivity(updateActivity, false);
            return resourceResponse;
        }));
        context.onDeleteActivity((ctx, reference, nextDel) -> ((CompletableFuture)nextDel.get()).thenApply(nextDelResult -> {
            Activity deleteActivity = new Activity("messageDelete");
            deleteActivity.setId(reference.getActivityId());
            deleteActivity.applyConversationReference(reference, false);
            this.logActivity(deleteActivity, false);
            return null;
        }));
        return next.next().thenAccept(nextResult -> {
            while (!this.transcript.isEmpty()) {
                Activity activity = this.transcript.poll();
                this.transcriptLogger.logActivity(activity);
            }
        });
    }

    private void logActivity(Activity activity, boolean incoming) {
        if (activity.getTimestamp() == null) {
            activity.setTimestamp(OffsetDateTime.now(ZoneId.of("UTC")));
        }
        if (activity.getFrom() == null) {
            activity.setFrom(new ChannelAccount());
        }
        if (activity.getFrom().getRole() == null) {
            activity.getFrom().setRole(incoming ? RoleTypes.USER : RoleTypes.BOT);
        }
        this.transcript.offer(activity);
    }
}

