/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.bot.connector.authentication.RetryParams;
import java.time.Duration;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class RetryAfterHelper {
    private RetryAfterHelper() {
    }

    public static RetryParams processRetry(List<String> header, Integer count) {
        if (header == null || header.size() == 0) {
            count = count + 1;
            return RetryParams.defaultBackOff(count);
        }
        String headerString = header.get(0);
        if (StringUtils.isNotBlank((CharSequence)headerString)) {
            if (headerString.matches("^[0-9]+\\.?0*$")) {
                headerString = headerString.replaceAll("\\.0*$", "");
                Duration delay = Duration.ofSeconds(Long.parseLong(headerString));
                return new RetryParams(delay.toMillis());
            }
            DateTimeFormatter gmtFormat = DateTimeFormatter.RFC_1123_DATE_TIME;
            try {
                ZonedDateTime zoned = ZonedDateTime.parse(headerString, gmtFormat);
                if (zoned != null) {
                    ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
                    long waitMillis = zoned.toInstant().toEpochMilli() - now.toInstant().toEpochMilli();
                    if (waitMillis > 0L) {
                        return new RetryParams(waitMillis);
                    }
                    count = count + 1;
                    return RetryParams.defaultBackOff(count);
                }
            }
            catch (DateTimeParseException ex) {
                count = count + 1;
                return RetryParams.defaultBackOff(count);
            }
        }
        count = count + 1;
        return RetryParams.defaultBackOff(count);
    }
}

