/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.rest;

import com.google.common.reflect.TypeToken;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.BotSignIn;
import com.microsoft.bot.connector.rest.ErrorResponseException;
import com.microsoft.bot.connector.rest.RestOAuthClient;
import com.microsoft.bot.restclient.ServiceResponse;
import com.microsoft.bot.schema.SignInResource;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Query;

public class RestBotSignIn
implements BotSignIn {
    private BotSignInsService service;
    private RestOAuthClient client;

    public RestBotSignIn(Retrofit withRetrofit, RestOAuthClient withClient) {
        this.service = (BotSignInsService)withRetrofit.create(BotSignInsService.class);
        this.client = withClient;
    }

    @Override
    public CompletableFuture<String> getSignInUrl(String state) {
        if (state == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter state is required and cannot be null."));
        }
        String codeChallenge = null;
        String emulatorUrl = null;
        String finalRedirect = null;
        return this.service.getSignInUrl(state, codeChallenge, emulatorUrl, finalRedirect).thenApply(responseBodyResponse -> {
            try {
                return this.getSignInUrlDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getSignInUrl", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    @Override
    public CompletableFuture<String> getSignInUrl(String state, String codeChallenge, String emulatorUrl, String finalRedirect) {
        if (state == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter state is required and cannot be null."));
        }
        return this.service.getSignInUrl(state, codeChallenge, emulatorUrl, finalRedirect).thenApply(responseBodyResponse -> {
            try {
                return this.getSignInUrlDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getSignInUrl", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<String> getSignInUrlDelegate(Response<ResponseBody> response) throws ErrorResponseException, IllegalArgumentException {
        if (!response.isSuccessful()) {
            throw new ErrorResponseException("getSignInUrl", response);
        }
        return new ServiceResponse<String>(((ResponseBody)response.body()).source().buffer().readUtf8(), response);
    }

    @Override
    public CompletableFuture<SignInResource> getSignInResource(String state) {
        if (state == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter state is required and cannot be null."));
        }
        String codeChallenge = null;
        String emulatorUrl = null;
        String finalRedirect = null;
        return this.service.getSignInResource(state, codeChallenge, emulatorUrl, finalRedirect).thenApply(responseBodyResponse -> {
            try {
                return this.getSignInResourceDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getSignInResource", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    @Override
    public CompletableFuture<SignInResource> getSignInResource(String state, String codeChallenge, String emulatorUrl, String finalRedirect) {
        if (state == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter state is required and cannot be null."));
        }
        return this.service.getSignInResource(state, codeChallenge, emulatorUrl, finalRedirect).thenApply(responseBodyResponse -> {
            try {
                return this.getSignInResourceDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getSignInResource", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<SignInResource> getSignInResourceDelegate(Response<ResponseBody> response) throws ErrorResponseException, IllegalArgumentException, IOException {
        if (!response.isSuccessful()) {
            throw new ErrorResponseException("getSignInResource", response);
        }
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SignInResource>(){}.getType()).register(301, new TypeToken<Void>(){}.getType()).register(302, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface BotSignInsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.BotSignIns getSignInUrl"})
        @GET(value="api/botsignin/GetSignInUrl")
        public CompletableFuture<Response<ResponseBody>> getSignInUrl(@Query(value="state") String var1, @Query(value="code_challenge") String var2, @Query(value="emulatorUrl") String var3, @Query(value="finalRedirect") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.BotSignIns GetSignInResource"})
        @GET(value="api/botsignin/GetSignInResource")
        public CompletableFuture<Response<ResponseBody>> getSignInResource(@Query(value="state") String var1, @Query(value="code_challenge") String var2, @Query(value="emulatorUrl") String var3, @Query(value="finalRedirect") String var4);
    }
}

