/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.rest;

import com.google.common.reflect.TypeToken;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.UserToken;
import com.microsoft.bot.connector.rest.ErrorResponseException;
import com.microsoft.bot.connector.rest.RestOAuthClient;
import com.microsoft.bot.restclient.ServiceResponse;
import com.microsoft.bot.restclient.Validator;
import com.microsoft.bot.schema.AadResourceUrls;
import com.microsoft.bot.schema.TokenExchangeRequest;
import com.microsoft.bot.schema.TokenResponse;
import com.microsoft.bot.schema.TokenStatus;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

public class RestUserToken
implements UserToken {
    private UserTokensService service;
    private RestOAuthClient client;

    public RestUserToken(Retrofit withRetrofit, RestOAuthClient withClient) {
        this.service = (UserTokensService)withRetrofit.create(UserTokensService.class);
        this.client = withClient;
    }

    @Override
    public CompletableFuture<TokenResponse> getToken(String userId, String connectionName) {
        if (userId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (connectionName == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        String channelId = null;
        String code = null;
        return this.service.getToken(userId, connectionName, channelId, code).thenApply(responseBodyResponse -> {
            try {
                return this.getTokenDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getToken", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    @Override
    public CompletableFuture<TokenResponse> getToken(String userId, String connectionName, String channelId, String code) {
        if (userId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (connectionName == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        return this.service.getToken(userId, connectionName, channelId, code).thenApply(responseBodyResponse -> {
            try {
                return this.getTokenDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getToken", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<TokenResponse> getTokenDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TokenResponse>(){}.getType()).register(404, new TypeToken<TokenResponse>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<TokenResponse> exchangeToken(String userId, String connectionName, String channelId, TokenExchangeRequest exchangeRequest) {
        if (userId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (connectionName == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        if (channelId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter channelId is required and cannot be null."));
        }
        if (exchangeRequest == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter exchangeRequest is required and cannot be null."));
        }
        return this.service.exchangeToken(userId, connectionName, channelId, exchangeRequest).thenApply(responseBodyResponse -> {
            try {
                return this.exchangeTokenDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getToken", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<TokenResponse> exchangeTokenDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TokenResponse>(){}.getType()).register(404, new TypeToken<TokenResponse>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<Map<String, TokenResponse>> getAadTokens(String userId, String connectionName, AadResourceUrls aadResourceUrls) {
        if (userId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (connectionName == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        if (aadResourceUrls == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter aadResourceUrls is required and cannot be null."));
        }
        Validator.validate(aadResourceUrls);
        String channelId = null;
        return this.service.getAadTokens(userId, connectionName, aadResourceUrls, channelId).thenApply(responseBodyResponse -> {
            try {
                return this.getAadTokensDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getAadTokens", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    @Override
    public CompletableFuture<Map<String, TokenResponse>> getAadTokens(String userId, String connectionName, AadResourceUrls aadResourceUrls, String channelId) {
        if (userId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (connectionName == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        if (aadResourceUrls == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter aadResourceUrls is required and cannot be null."));
        }
        return Async.tryCompletable(() -> {
            Validator.validate(aadResourceUrls);
            return this.service.getAadTokens(userId, connectionName, aadResourceUrls, channelId).thenApply(responseBodyResponse -> {
                try {
                    return this.getAadTokensDelegate((Response<ResponseBody>)responseBodyResponse).body();
                }
                catch (ErrorResponseException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new ErrorResponseException("getAadTokens", (Response<ResponseBody>)responseBodyResponse);
                }
            });
        });
    }

    private ServiceResponse<Map<String, TokenResponse>> getAadTokensDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Map<String, TokenResponse>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<Object> signOut(String userId) {
        if (userId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        return this.service.signOut(userId).thenApply(responseBodyResponse -> {
            try {
                return this.signOutDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("signOut", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    @Override
    public CompletableFuture<Object> signOut(String userId, String connectionName, String channelId) {
        if (userId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (connectionName == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter connectionName is required and cannot be null."));
        }
        if (channelId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter channelId is required and cannot be null."));
        }
        return this.service.signOut(userId, connectionName, channelId).thenApply(responseBodyResponse -> {
            try {
                return this.signOutDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("signOut", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<Object> signOutDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Object>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<List<TokenStatus>> getTokenStatus(String userId) {
        if (userId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String channelId = null;
        String include = null;
        return this.service.getTokenStatus(userId, channelId, include).thenApply(responseBodyResponse -> {
            try {
                return this.getTokenStatusDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getTokenStatus", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    @Override
    public CompletableFuture<List<TokenStatus>> getTokenStatus(String userId, String channelId, String include) {
        if (userId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        return this.service.getTokenStatus(userId, channelId, include).thenApply(responseBodyResponse -> {
            try {
                return this.getTokenStatusDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getTokenStatus", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<List<TokenStatus>> getTokenStatusDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<TokenStatus>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<Void> sendEmulateOAuthCards(boolean emulateOAuthCards) {
        return this.service.sendEmulateOAuthCards(emulateOAuthCards).thenApply(responseBodyResponse -> {
            try {
                return this.sendEmulateOAuthCardsDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("sendEmulateOAuthCards", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<Void> sendEmulateOAuthCardsDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface UserTokensService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.UserTokens getToken"})
        @GET(value="api/usertoken/GetToken")
        public CompletableFuture<Response<ResponseBody>> getToken(@Query(value="userId") String var1, @Query(value="connectionName") String var2, @Query(value="channelId") String var3, @Query(value="code") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.UserTokens exchangeToken"})
        @POST(value="api/usertoken/Exchange")
        public CompletableFuture<Response<ResponseBody>> exchangeToken(@Query(value="userId") String var1, @Query(value="connectionName") String var2, @Query(value="channelId") String var3, @Body TokenExchangeRequest var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.UserTokens getAadTokens"})
        @POST(value="api/usertoken/GetAadTokens")
        public CompletableFuture<Response<ResponseBody>> getAadTokens(@Query(value="userId") String var1, @Query(value="connectionName") String var2, @Body AadResourceUrls var3, @Query(value="channelId") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.UserTokens signOut"})
        @HTTP(path="api/usertoken/SignOut", method="DELETE", hasBody=true)
        public CompletableFuture<Response<ResponseBody>> signOut(@Query(value="userId") String var1, @Query(value="connectionName") String var2, @Query(value="channelId") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.UserTokens signOut"})
        @HTTP(path="api/usertoken/SignOut", method="DELETE", hasBody=true)
        public CompletableFuture<Response<ResponseBody>> signOut(@Query(value="userId") String var1);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.UserTokens getTokenStatus"})
        @GET(value="api/usertoken/GetTokenStatus")
        public CompletableFuture<Response<ResponseBody>> getTokenStatus(@Query(value="userId") String var1, @Query(value="channelId") String var2, @Query(value="include") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.UserTokens sendEmulateOAuthCards"})
        @POST(value="api/usertoken/emulateOAuthCards")
        public CompletableFuture<Response<ResponseBody>> sendEmulateOAuthCards(@Query(value="emulate") boolean var1);
    }
}

