/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.authentication.ClaimsValidator;
import com.microsoft.bot.connector.authentication.JwtTokenValidation;
import com.microsoft.bot.connector.authentication.SkillValidation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class AllowedCallersClaimsValidator
extends ClaimsValidator {
    private List<String> allowedCallers;

    public AllowedCallersClaimsValidator(List<String> withAllowedCallers) {
        this.allowedCallers = withAllowedCallers != null ? withAllowedCallers : new ArrayList();
    }

    @Override
    public CompletableFuture<Void> validateClaims(Map<String, String> claims) {
        String appId;
        if (claims == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Claims cannot be null"));
        }
        if (SkillValidation.isSkillClaim(claims).booleanValue() && !this.allowedCallers.contains("*") && !this.allowedCallers.contains(appId = JwtTokenValidation.getAppIdFromClaims(claims))) {
            return Async.completeExceptionally(new RuntimeException(String.format("Received a request from a bot with an app ID of \"%s\". To enable requests from this caller, add the app ID to the configured set of allowedCallers.", appId)));
        }
        return CompletableFuture.completedFuture(null);
    }
}

