/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.rest;

import com.google.common.reflect.TypeToken;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.Conversations;
import com.microsoft.bot.connector.rest.ErrorResponseException;
import com.microsoft.bot.connector.rest.RestConnectorClient;
import com.microsoft.bot.restclient.ServiceResponse;
import com.microsoft.bot.restclient.ServiceResponseBuilder;
import com.microsoft.bot.restclient.Validator;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.AttachmentData;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.ConversationParameters;
import com.microsoft.bot.schema.ConversationResourceResponse;
import com.microsoft.bot.schema.ConversationsResult;
import com.microsoft.bot.schema.PagedMembersResult;
import com.microsoft.bot.schema.ResourceResponse;
import com.microsoft.bot.schema.Transcript;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public class RestConversations
implements Conversations {
    private ConversationsService service;
    private RestConnectorClient client;

    RestConversations(Retrofit withRetrofit, RestConnectorClient withClient) {
        this.service = (ConversationsService)withRetrofit.create(ConversationsService.class);
        this.client = withClient;
    }

    @Override
    public CompletableFuture<ConversationsResult> getConversations() {
        return this.getConversations(null);
    }

    @Override
    public CompletableFuture<ConversationsResult> getConversations(String continuationToken) {
        return this.service.getConversations(continuationToken, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.getConversationsDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getConversations", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<ConversationsResult> getConversationsDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ConversationsResult>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<ConversationResourceResponse> createConversation(ConversationParameters parameters) {
        if (parameters == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        Validator.validate(parameters);
        return this.service.createConversation(parameters, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.createConversationDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("createConversation", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<ConversationResourceResponse> createConversationDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ConversationResourceResponse>(){}.getType()).register(201, new TypeToken<ConversationResourceResponse>(){}.getType()).register(202, new TypeToken<ConversationResourceResponse>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<ResourceResponse> sendToConversation(String conversationId, Activity activity) {
        if (conversationId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter conversationId is required and cannot be null."));
        }
        if (activity == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter activity is required and cannot be null."));
        }
        Validator.validate(activity);
        return this.service.sendToConversation(conversationId, activity, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.sendToConversationDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("sendToConversation", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<ResourceResponse> sendToConversationDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceResponse>(){}.getType()).register(201, new TypeToken<ResourceResponse>(){}.getType()).register(202, new TypeToken<ResourceResponse>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<ResourceResponse> updateActivity(String conversationId, String activityId, Activity activity) {
        if (conversationId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter conversationId is required and cannot be null."));
        }
        if (activityId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter activityId is required and cannot be null."));
        }
        if (activity == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter activity is required and cannot be null."));
        }
        return Async.tryCompletable(() -> {
            Validator.validate(activity);
            return this.service.updateActivity(conversationId, activityId, activity, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
                try {
                    return this.updateActivityDelegate((Response<ResponseBody>)responseBodyResponse).body();
                }
                catch (ErrorResponseException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new ErrorResponseException("updateActivity", (Response<ResponseBody>)responseBodyResponse);
                }
            });
        });
    }

    private ServiceResponse<ResourceResponse> updateActivityDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceResponse>(){}.getType()).register(201, new TypeToken<ResourceResponse>(){}.getType()).register(202, new TypeToken<ResourceResponse>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<ResourceResponse> replyToActivity(String conversationId, String activityId, Activity activity) {
        if (conversationId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter conversationId is required and cannot be null."));
        }
        if (activityId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter activityId is required and cannot be null."));
        }
        if (activity == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter activity is required and cannot be null."));
        }
        Validator.validate(activity);
        return this.service.replyToActivity(conversationId, activityId, activity, this.client.getAcceptLanguage(), this.client.getUserAgent(), conversationId).thenApply(responseBodyResponse -> {
            try {
                return this.replyToActivityDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("replyToActivity", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<ResourceResponse> replyToActivityDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceResponse>(){}.getType()).register(201, new TypeToken<ResourceResponse>(){}.getType()).register(202, new TypeToken<ResourceResponse>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<Void> deleteActivity(String conversationId, String activityId) {
        if (conversationId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter conversationId is required and cannot be null."));
        }
        if (activityId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter activityId is required and cannot be null."));
        }
        return this.service.deleteActivity(conversationId, activityId, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.deleteActivityDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("deleteActivity", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<Void> deleteActivityDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<List<ChannelAccount>> getConversationMembers(String conversationId) {
        if (conversationId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter conversationId is required and cannot be null."));
        }
        return this.service.getConversationMembers(conversationId, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.getConversationMembersDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getConversationMembers", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<List<ChannelAccount>> getConversationMembersDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<ChannelAccount>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<ChannelAccount> getConversationMember(String userId, String conversationId) {
        if (userId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (conversationId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter conversationId is required and cannot be null."));
        }
        return this.service.getConversationMember(userId, conversationId, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.getConversationMemberDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getConversationMember", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<ChannelAccount> getConversationMemberDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return ((ServiceResponseBuilder)this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ChannelAccount>(){}.getType()).registerError(ErrorResponseException.class)).withThrowOnGet404(true).build(response);
    }

    @Override
    public CompletableFuture<Void> deleteConversationMember(String conversationId, String memberId) {
        if (conversationId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter conversationId is required and cannot be null."));
        }
        if (memberId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter memberId is required and cannot be null."));
        }
        return this.service.deleteConversationMember(conversationId, memberId, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.deleteConversationMemberDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("deleteConversationMember", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<Void> deleteConversationMemberDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<List<ChannelAccount>> getActivityMembers(String conversationId, String activityId) {
        if (conversationId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter conversationId is required and cannot be null."));
        }
        if (activityId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter activityId is required and cannot be null."));
        }
        return this.service.getActivityMembers(conversationId, activityId, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.getActivityMembersDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getActivityMembers", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<List<ChannelAccount>> getActivityMembersDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<ChannelAccount>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<ResourceResponse> uploadAttachment(String conversationId, AttachmentData attachmentUpload) {
        if (conversationId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter conversationId is required and cannot be null."));
        }
        if (attachmentUpload == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter attachmentUpload is required and cannot be null."));
        }
        Validator.validate(attachmentUpload);
        return this.service.uploadAttachment(conversationId, attachmentUpload, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.uploadAttachmentDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("uploadAttachment", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<ResourceResponse> uploadAttachmentDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceResponse>(){}.getType()).register(201, new TypeToken<ResourceResponse>(){}.getType()).register(202, new TypeToken<ResourceResponse>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<ResourceResponse> sendConversationHistory(String conversationId, Transcript history) {
        if (conversationId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter conversationId is required and cannot be null."));
        }
        if (history == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter history is required and cannot be null."));
        }
        Validator.validate(history);
        return this.service.sendConversationHistory(conversationId, history, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.sendConversationHistoryDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("sendConversationHistory", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<ResourceResponse> sendConversationHistoryDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceResponse>(){}.getType()).register(201, new TypeToken<ResourceResponse>(){}.getType()).register(202, new TypeToken<ResourceResponse>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<PagedMembersResult> getConversationPagedMembers(String conversationId) {
        if (conversationId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter conversationId is required and cannot be null."));
        }
        return this.service.getConversationPagedMembers(conversationId, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.getConversationPagedMembersDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getConversationPagedMembers", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<PagedMembersResult> getConversationPagedMembersDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PagedMembersResult>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<PagedMembersResult> getConversationPagedMembers(String conversationId, String continuationToken) {
        if (conversationId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter conversationId is required and cannot be null."));
        }
        if (continuationToken == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter continuationToken is required and cannot be null."));
        }
        return this.service.getConversationPagedMembers(conversationId, continuationToken, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.getConversationPagedMembers2Delegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getConversationPagedMembers", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<PagedMembersResult> getConversationPagedMembers2Delegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PagedMembersResult>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface ConversationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations getConversations"})
        @GET(value="v3/conversations")
        public CompletableFuture<Response<ResponseBody>> getConversations(@Query(value="continuationToken") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations createConversation"})
        @POST(value="v3/conversations")
        public CompletableFuture<Response<ResponseBody>> createConversation(@Body ConversationParameters var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations sendToConversation"})
        @POST(value="v3/conversations/{conversationId}/activities")
        public CompletableFuture<Response<ResponseBody>> sendToConversation(@Path(value="conversationId") String var1, @Body Activity var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations updateActivity"})
        @PUT(value="v3/conversations/{conversationId}/activities/{activityId}")
        public CompletableFuture<Response<ResponseBody>> updateActivity(@Path(value="conversationId") String var1, @Path(value="activityId") String var2, @Body Activity var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations replyToActivity"})
        @POST(value="v3/conversations/{conversationId}/activities/{activityId}")
        public CompletableFuture<Response<ResponseBody>> replyToActivity(@Path(value="conversationId") String var1, @Path(value="activityId") String var2, @Body Activity var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5, @Header(value="x-ms-conversation-id") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations deleteActivity"})
        @HTTP(path="v3/conversations/{conversationId}/activities/{activityId}", method="DELETE", hasBody=true)
        public CompletableFuture<Response<ResponseBody>> deleteActivity(@Path(value="conversationId") String var1, @Path(value="activityId") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations getConversationMembers"})
        @GET(value="v3/conversations/{conversationId}/members")
        public CompletableFuture<Response<ResponseBody>> getConversationMembers(@Path(value="conversationId") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations getConversationMembers"})
        @GET(value="v3/conversations/{conversationId}/members/{userId}")
        public CompletableFuture<Response<ResponseBody>> getConversationMember(@Path(value="userId") String var1, @Path(value="conversationId") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations deleteConversationMember"})
        @HTTP(path="v3/conversations/{conversationId}/members/{memberId}", method="DELETE", hasBody=true)
        public CompletableFuture<Response<ResponseBody>> deleteConversationMember(@Path(value="conversationId") String var1, @Path(value="memberId") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations getActivityMembers"})
        @GET(value="v3/conversations/{conversationId}/activities/{activityId}/members")
        public CompletableFuture<Response<ResponseBody>> getActivityMembers(@Path(value="conversationId") String var1, @Path(value="activityId") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations uploadAttachment"})
        @POST(value="v3/conversations/{conversationId}/attachments")
        public CompletableFuture<Response<ResponseBody>> uploadAttachment(@Path(value="conversationId") String var1, @Body AttachmentData var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations sendConversationHistory"})
        @POST(value="v3/conversations/{conversationId}/activities/history")
        public CompletableFuture<Response<ResponseBody>> sendConversationHistory(@Path(value="conversationId") String var1, @Body Transcript var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations getConversationPagedMembers"})
        @GET(value="v3/conversations/{conversationId}/pagedmembers")
        public CompletableFuture<Response<ResponseBody>> getConversationPagedMembers(@Path(value="conversationId") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Conversations getConversationPagedMembers"})
        @GET(value="v3/conversations/{conversationId}/pagedmembers?continuationToken={continuationToken}")
        public CompletableFuture<Response<ResponseBody>> getConversationPagedMembers(@Path(value="conversationId") String var1, @Path(value="continuationToken") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

