/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.integration.spring;

import com.microsoft.bot.builder.Bot;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.integration.BotFrameworkHttpAdapter;
import com.microsoft.bot.schema.Activity;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BotController {
    private Logger logger = LoggerFactory.getLogger(BotController.class);
    private final BotFrameworkHttpAdapter adapter;
    private final Bot bot;

    public BotController(BotFrameworkHttpAdapter withAdapter, Bot withBot) {
        this.adapter = withAdapter;
        this.bot = withBot;
    }

    @PostMapping(value={"/api/messages"})
    public CompletableFuture<ResponseEntity<Object>> incoming(@RequestBody Activity activity, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.adapter.processIncomingActivity(authHeader, activity, this.bot).handle((result, exception) -> {
            if (exception == null) {
                if (result != null) {
                    return new ResponseEntity(result.getBody(), HttpStatus.valueOf((int)result.getStatus()));
                }
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }
}

