/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.integration.spring;

import com.microsoft.bot.builder.ConversationState;
import com.microsoft.bot.builder.MemoryStorage;
import com.microsoft.bot.builder.Storage;
import com.microsoft.bot.builder.UserState;
import com.microsoft.bot.builder.inspection.InspectionState;
import com.microsoft.bot.connector.ExecutorFactory;
import com.microsoft.bot.connector.authentication.AuthenticationConfiguration;
import com.microsoft.bot.connector.authentication.ChannelProvider;
import com.microsoft.bot.connector.authentication.CredentialProvider;
import com.microsoft.bot.integration.BotFrameworkHttpAdapter;
import com.microsoft.bot.integration.ClasspathPropertiesConfiguration;
import com.microsoft.bot.integration.Configuration;
import com.microsoft.bot.integration.ConfigurationChannelProvider;
import com.microsoft.bot.integration.ConfigurationCredentialProvider;
import java.util.concurrent.ExecutorService;
import org.springframework.context.annotation.Bean;

public abstract class BotDependencyConfiguration {
    @Bean
    public ExecutorService getExecutorService() {
        return ExecutorFactory.getExecutor();
    }

    @Bean
    public Configuration getConfiguration() {
        return new ClasspathPropertiesConfiguration();
    }

    @Bean
    public AuthenticationConfiguration getAuthenticationConfiguration(Configuration configuration) {
        return new AuthenticationConfiguration();
    }

    @Bean
    public CredentialProvider getCredentialProvider(Configuration configuration) {
        return new ConfigurationCredentialProvider(configuration);
    }

    @Bean
    public ChannelProvider getChannelProvider(Configuration configuration) {
        return new ConfigurationChannelProvider(configuration);
    }

    @Bean
    public BotFrameworkHttpAdapter getBotFrameworkHttpAdaptor(Configuration configuration) {
        return new BotFrameworkHttpAdapter(configuration);
    }

    @Bean
    public Storage getStorage() {
        return new MemoryStorage();
    }

    @Bean
    public ConversationState getConversationState(Storage storage) {
        return new ConversationState(storage);
    }

    @Bean
    public UserState getUserState(Storage storage) {
        return new UserState(storage);
    }

    @Bean
    public InspectionState getInspectionState(Storage storage) {
        return new InspectionState(storage);
    }
}

