/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.integration.spring;

import com.microsoft.bot.builder.ChannelServiceHandler;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.integration.spring.BotController;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.AttachmentData;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.ConversationParameters;
import com.microsoft.bot.schema.ConversationResourceResponse;
import com.microsoft.bot.schema.ConversationsResult;
import com.microsoft.bot.schema.PagedMembersResult;
import com.microsoft.bot.schema.ResourceResponse;
import com.microsoft.bot.schema.Transcript;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class ChannelServiceController {
    private Logger logger = LoggerFactory.getLogger(BotController.class);
    private final ChannelServiceHandler handler;

    protected ChannelServiceController(ChannelServiceHandler handler) {
        this.handler = handler;
    }

    @PostMapping(value={"v3/conversations/{conversationId}/activities"})
    public CompletableFuture<ResponseEntity<ResourceResponse>> sendToConversation(@PathVariable String conversationId, @RequestBody Activity activity, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.handler.handleSendToConversation(authHeader, conversationId, activity).handle((result, exception) -> {
            if (exception == null) {
                if (result != null) {
                    return new ResponseEntity(result, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @PostMapping(value={"v3/conversations/{conversationId}/activities/{activityId}"})
    public CompletableFuture<ResponseEntity<ResourceResponse>> replyToActivity(@PathVariable String conversationId, @PathVariable String activityId, @RequestBody Activity activity, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.handler.handleReplyToActivity(authHeader, conversationId, activityId, activity).handle((result, exception) -> {
            if (exception == null) {
                if (result != null) {
                    return new ResponseEntity(result, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @PutMapping(value={"v3/conversations/{conversationId}/activities/{activityId}"})
    public CompletableFuture<ResponseEntity<ResourceResponse>> updateActivity(@PathVariable String conversationId, @PathVariable String activityId, @RequestBody Activity activity, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.handler.handleUpdateActivity(authHeader, conversationId, activityId, activity).handle((result, exception) -> {
            if (exception == null) {
                if (result != null) {
                    return new ResponseEntity(result, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @DeleteMapping(value={"v3/conversations/{conversationId}/activities/{activityId}"})
    public CompletableFuture<ResponseEntity<Void>> deleteActivity(@PathVariable String conversationId, @PathVariable String activityId, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.handler.handleDeleteActivity(authHeader, conversationId, activityId).handle((result, exception) -> {
            if (exception == null) {
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @GetMapping(value={"v3/conversations/{conversationId}/activities/{activityId}/members"})
    public CompletableFuture<ResponseEntity<List<ChannelAccount>>> getActivityMembers(@PathVariable String conversationId, @PathVariable String activityId, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.handler.handleGetActivityMembers(authHeader, conversationId, activityId).handle((result, exception) -> {
            if (exception == null) {
                if (result != null) {
                    return new ResponseEntity(result, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @PostMapping(value={"v3/conversations"})
    public CompletableFuture<ResponseEntity<ConversationResourceResponse>> createConversation(@RequestBody ConversationParameters parameters, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.handler.handleCreateConversation(authHeader, parameters).handle((result, exception) -> {
            if (exception == null) {
                if (result != null) {
                    return new ResponseEntity(result, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @GetMapping(value={"v3/conversations"})
    public CompletableFuture<ResponseEntity<ConversationsResult>> getConversations(@RequestParam String conversationId, @RequestParam String continuationToken, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.handler.handleGetConversations(authHeader, conversationId, continuationToken).handle((result, exception) -> {
            if (exception == null) {
                if (result != null) {
                    return new ResponseEntity(result, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @GetMapping(value={"v3/conversations/{conversationId}/members"})
    public CompletableFuture<ResponseEntity<List<ChannelAccount>>> getConversationMembers(@PathVariable String conversationId, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.handler.handleGetConversationMembers(authHeader, conversationId).handle((result, exception) -> {
            if (exception == null) {
                if (result != null) {
                    return new ResponseEntity(result, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @GetMapping(value={"v3/conversations/{conversationId}/pagedmembers"})
    public CompletableFuture<ResponseEntity<PagedMembersResult>> getConversationPagedMembers(@PathVariable String conversationId, @RequestParam(name="pageSize", defaultValue="-1") int pageSize, @RequestParam(name="continuationToken") String continuationToken, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.handler.handleGetConversationPagedMembers(authHeader, conversationId, Integer.valueOf(pageSize), continuationToken).handle((result, exception) -> {
            if (exception == null) {
                if (result != null) {
                    return new ResponseEntity(result, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @DeleteMapping(value={"v3/conversations/{conversationId}/members/{memberId}"})
    public CompletableFuture<ResponseEntity<Void>> deleteConversationMember(@PathVariable String conversationId, @PathVariable String memberId, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.handler.handleDeleteConversationMember(authHeader, conversationId, memberId).handle((result, exception) -> {
            if (exception == null) {
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @PostMapping(value={"v3/conversations/{conversationId}/activities/history"})
    public CompletableFuture<ResponseEntity<ResourceResponse>> sendConversationHistory(@PathVariable String conversationId, @RequestBody Transcript history, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.handler.handleSendConversationHistory(authHeader, conversationId, history).handle((result, exception) -> {
            if (exception == null) {
                if (result != null) {
                    return new ResponseEntity(result, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @PostMapping(value={"v3/conversations/{conversationId}/attachments"})
    public CompletableFuture<ResponseEntity<ResourceResponse>> uploadAttachment(@PathVariable String conversationId, @RequestBody AttachmentData attachmentUpload, @RequestHeader(value="Authorization", defaultValue="") String authHeader) {
        return this.handler.handleUploadAttachment(authHeader, conversationId, attachmentUpload).handle((result, exception) -> {
            if (exception == null) {
                if (result != null) {
                    return new ResponseEntity(result, HttpStatus.OK);
                }
                return new ResponseEntity(HttpStatus.ACCEPTED);
            }
            this.logger.error("Exception handling message", exception);
            if (exception instanceof CompletionException) {
                if (exception.getCause() instanceof AuthenticationException) {
                    return new ResponseEntity(HttpStatus.UNAUTHORIZED);
                }
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
        });
    }
}

