/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.schema;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.bot.schema.RoleTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ChannelAccount {
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String id;
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String name;
    @JsonProperty(value="aadObjectId")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String aadObjectId;
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private RoleTypes role;
    private HashMap<String, JsonNode> properties = new HashMap();

    public static ChannelAccount clone(ChannelAccount channelAccount) {
        if (channelAccount == null) {
            return null;
        }
        ChannelAccount cloned = new ChannelAccount();
        cloned.setId(channelAccount.getId());
        cloned.setRole(channelAccount.getRole());
        cloned.setName(channelAccount.getName());
        cloned.setAadObjectId(channelAccount.getAadObjectId());
        for (String key : channelAccount.getProperties().keySet()) {
            cloned.setProperties(key, channelAccount.getProperties().get(key));
        }
        return cloned;
    }

    public static List<ChannelAccount> cloneList(List<ChannelAccount> channelAccounts) {
        if (channelAccounts == null) {
            return null;
        }
        return channelAccounts.stream().map(channelAccount -> ChannelAccount.clone(channelAccount)).collect(Collectors.toCollection(ArrayList::new));
    }

    public ChannelAccount() {
    }

    public ChannelAccount(String withId) {
        this(withId, null, null, null);
    }

    public ChannelAccount(String withId, String withName) {
        this(withId, withName, null, null);
    }

    public ChannelAccount(String withId, String withName, RoleTypes withRole) {
        this(withId, withName, withRole, null);
    }

    public ChannelAccount(String withId, String withName, RoleTypes withRole, String withAadObjectId) {
        this.id = withId;
        this.name = withName;
        this.role = withRole;
        this.aadObjectId = withAadObjectId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String withId) {
        this.id = withId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String withName) {
        this.name = withName;
    }

    public RoleTypes getRole() {
        return this.role;
    }

    public void setRole(RoleTypes withRole) {
        this.role = withRole;
    }

    @JsonAnyGetter
    public Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    @JsonAnySetter
    public void setProperties(String key, JsonNode value) {
        this.properties.put(key, value);
    }

    public String getAadObjectId() {
        return this.aadObjectId;
    }

    public void setAadObjectId(String withAadObjectId) {
        this.aadObjectId = withAadObjectId;
    }
}

