/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.schema;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.bot.schema.Activity;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.ConversationAccount;
import java.util.UUID;

public class ConversationReference {
    @JsonProperty(value="activityId")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String activityId;
    @JsonProperty(value="user")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private ChannelAccount user;
    @JsonProperty(value="bot")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private ChannelAccount bot;
    @JsonProperty(value="conversation")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private ConversationAccount conversation;
    @JsonProperty(value="channelId")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String channelId;
    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String locale;
    @JsonProperty(value="serviceUrl")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String serviceUrl;

    public static ConversationReference clone(ConversationReference conversationReference) {
        if (conversationReference == null) {
            return null;
        }
        ConversationReference cloned = new ConversationReference();
        cloned.setActivityId(conversationReference.getActivityId());
        cloned.setBot(ChannelAccount.clone(conversationReference.getBot()));
        cloned.setUser(ChannelAccount.clone(conversationReference.getUser()));
        cloned.setConversation(ConversationAccount.clone(conversationReference.getConversation()));
        cloned.setServiceUrl(conversationReference.getServiceUrl());
        cloned.setLocale(conversationReference.getLocale());
        cloned.setChannelId(conversationReference.getChannelId());
        return cloned;
    }

    @JsonIgnore
    public Activity getContinuationActivity() {
        Activity activity = Activity.createEventActivity();
        activity.setName("ContinueConversation");
        activity.setId(UUID.randomUUID().toString());
        activity.setChannelId(this.getChannelId());
        activity.setConversation(this.getConversation());
        activity.setRecipient(this.getBot());
        activity.setLocale(this.getLocale());
        activity.setServiceUrl(this.getServiceUrl());
        activity.setFrom(this.getUser());
        activity.setRelatesTo(this);
        return activity;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String withActivityId) {
        this.activityId = withActivityId;
    }

    public ChannelAccount getUser() {
        return this.user;
    }

    public void setUser(ChannelAccount withUser) {
        this.user = withUser;
    }

    public ChannelAccount getBot() {
        return this.bot;
    }

    public void setBot(ChannelAccount withBot) {
        this.bot = withBot;
    }

    public ConversationAccount getConversation() {
        return this.conversation;
    }

    public void setConversation(ConversationAccount withConversation) {
        this.conversation = withConversation;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String withChannelId) {
        this.channelId = withChannelId;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String withLocale) {
        this.locale = withLocale;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String withServiceUrl) {
        this.serviceUrl = withServiceUrl;
    }
}

