/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.schema;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;

public class NanoClockHelper
extends Clock {
    private final Clock clock;
    private final long initialNanos;
    private final Instant initialInstant;

    public NanoClockHelper() {
        this(Clock.systemUTC());
    }

    public NanoClockHelper(Clock clock) {
        this.clock = clock;
        this.initialInstant = clock.instant();
        this.initialNanos = this.getSystemNanos();
    }

    @Override
    public ZoneId getZone() {
        return this.clock.getZone();
    }

    @Override
    public Instant instant() {
        return this.initialInstant.plusNanos(this.getSystemNanos() - this.initialNanos);
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return new NanoClockHelper(this.clock.withZone(zone));
    }

    private long getSystemNanos() {
        return System.nanoTime();
    }
}

