/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.schema;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.bot.schema.Attachment;
import com.microsoft.bot.schema.AttachmentLayoutTypes;
import com.microsoft.bot.schema.ChannelAccount;
import com.microsoft.bot.schema.ConversationAccount;
import com.microsoft.bot.schema.ConversationReference;
import com.microsoft.bot.schema.EndOfConversationCodes;
import com.microsoft.bot.schema.Entity;
import com.microsoft.bot.schema.InputHints;
import com.microsoft.bot.schema.Mention;
import com.microsoft.bot.schema.MessageReaction;
import com.microsoft.bot.schema.NanoClockHelper;
import com.microsoft.bot.schema.ResourceResponse;
import com.microsoft.bot.schema.ResultPair;
import com.microsoft.bot.schema.SuggestedActions;
import com.microsoft.bot.schema.TextFormatTypes;
import com.microsoft.bot.schema.TextHighlight;
import com.microsoft.bot.schema.teams.NotificationInfo;
import com.microsoft.bot.schema.teams.TeamInfo;
import com.microsoft.bot.schema.teams.TeamsChannelData;
import com.microsoft.bot.schema.teams.TeamsMeetingInfo;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Activity {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String type;
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String id;
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.nXXX", timezone="UTC")
    private OffsetDateTime timestamp;
    @JsonProperty(value="localTimestamp")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private OffsetDateTime localTimestamp;
    @JsonProperty(value="localTimezone")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String localTimezone;
    @JsonProperty(value="callerId")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String callerId;
    @JsonProperty(value="serviceUrl")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String serviceUrl;
    @JsonProperty(value="channelId")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String channelId;
    @JsonProperty(value="from")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private ChannelAccount from;
    @JsonProperty(value="conversation")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private ConversationAccount conversation;
    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private ChannelAccount recipient;
    @JsonProperty(value="textFormat")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private TextFormatTypes textFormat;
    @JsonProperty(value="attachmentLayout")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private AttachmentLayoutTypes attachmentLayout;
    @JsonProperty(value="membersAdded")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<ChannelAccount> membersAdded;
    @JsonProperty(value="membersRemoved")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<ChannelAccount> membersRemoved;
    @JsonProperty(value="reactionsAdded")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<MessageReaction> reactionsAdded;
    @JsonProperty(value="reactionsRemoved")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<MessageReaction> reactionsRemoved;
    @JsonProperty(value="topicName")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String topicName;
    @JsonProperty(value="historyDisclosed")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private boolean historyDisclosed;
    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String locale;
    @JsonProperty(value="text")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String text;
    @JsonProperty(value="speak")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String speak;
    @JsonProperty(value="inputHint")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private InputHints inputHint;
    @JsonProperty(value="summary")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String summary;
    @JsonProperty(value="suggestedActions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private SuggestedActions suggestedActions;
    @JsonProperty(value="attachments")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Attachment> attachments;
    @JsonProperty(value="entities")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Entity> entities;
    @JsonProperty(value="channelData")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Object channelData;
    @JsonProperty(value="action")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String action;
    @JsonProperty(value="replyToId")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String replyToId;
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String label;
    @JsonProperty(value="valueType")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String valueType;
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Object value;
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String name;
    @JsonProperty(value="relatesTo")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private ConversationReference relatesTo;
    @JsonProperty(value="code")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private EndOfConversationCodes code;
    @JsonProperty(value="expiration")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private LocalDateTime expiration;
    @JsonProperty(value="importance")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String importance;
    @JsonProperty(value="deliveryMode")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String deliveryMode;
    @JsonProperty(value="listenFor")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<String> listenFor;
    @JsonProperty(value="textHighlights")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<TextHighlight> textHighlights;
    private HashMap<String, JsonNode> properties = new HashMap();

    protected Activity() {
        NanoClockHelper clock = new NanoClockHelper();
        this.setTimestamp(OffsetDateTime.now(clock));
    }

    public Activity(String withType) {
        this();
        this.setType(withType);
    }

    public static Activity createTraceActivity(String withName) {
        return Activity.createTraceActivity(withName, null, null, null);
    }

    public static Activity createTraceActivity(String withName, String withValueType, Object withValue, String withLabel) {
        Activity activity = new Activity("trace");
        activity.setName(withName);
        activity.setLabel(withLabel);
        if (withValue != null) {
            activity.setValueType(withValueType == null ? withValue.getClass().getTypeName() : withValueType);
        } else {
            activity.setValueType(withValueType);
        }
        activity.setValue(withValue);
        return activity;
    }

    public static Activity createMessageActivity() {
        Activity activity = new Activity("message");
        activity.setAttachments(new ArrayList<Attachment>());
        activity.setEntities(new ArrayList<Entity>());
        return activity;
    }

    public static Activity createContactRelationUpdateActivity() {
        return new Activity("contactRelationUpdate");
    }

    public static Activity createConversationUpdateActivity() {
        Activity activity = new Activity("conversationUpdate");
        activity.setMembersAdded(new ArrayList<ChannelAccount>());
        activity.setMembersRemoved(new ArrayList<ChannelAccount>());
        return activity;
    }

    public static Activity createTypingActivity() {
        return new Activity("typing");
    }

    public static Activity createHandoffActivity() {
        return new Activity("handoff");
    }

    public static Activity createEndOfConversationActivity() {
        return new Activity("endOfConversation");
    }

    public static Activity createEventActivity() {
        return new Activity("event");
    }

    public static Activity createInvokeActivity() {
        return new Activity("invoke");
    }

    public static Activity clone(Activity activity) {
        Activity cloned = new Activity(activity.getType());
        cloned.setId(activity.getId());
        cloned.setTimestamp(activity.getTimestamp());
        cloned.setLocalTimestamp(activity.getLocalTimestamp());
        cloned.setLocalTimeZone(activity.getLocalTimezone());
        cloned.setChannelData(activity.getChannelData());
        cloned.setFrom(ChannelAccount.clone(activity.getFrom()));
        cloned.setRecipient(ChannelAccount.clone(activity.getRecipient()));
        cloned.setConversation(ConversationAccount.clone(activity.getConversation()));
        cloned.setChannelId(activity.getChannelId());
        cloned.setServiceUrl(activity.getServiceUrl());
        cloned.setChannelId(activity.getChannelId());
        cloned.setEntities(Entity.cloneList(activity.getEntities()));
        cloned.setReplyToId(activity.getReplyToId());
        cloned.setSpeak(activity.getSpeak());
        cloned.setText(activity.getText());
        cloned.setInputHint(activity.getInputHint());
        cloned.setSummary(activity.getSummary());
        cloned.setSuggestedActions(SuggestedActions.clone(activity.getSuggestedActions()));
        cloned.setAttachments(Attachment.cloneList(activity.getAttachments()));
        cloned.setAction(activity.getAction());
        cloned.setLabel(activity.getLabel());
        cloned.setValueType(activity.getValueType());
        cloned.setValue(activity.getValue());
        cloned.setName(activity.getName());
        cloned.setRelatesTo(ConversationReference.clone(activity.getRelatesTo()));
        cloned.setCode(activity.getCode());
        cloned.setExpiration(activity.getExpiration());
        cloned.setImportance(activity.getImportance());
        cloned.setDeliveryMode(activity.getDeliveryMode());
        cloned.setTextHighlights(activity.getTextHighlights());
        cloned.setCallerId(activity.getCallerId());
        cloned.setHistoryDisclosed(activity.getHistoryDisclosed());
        cloned.setLocale(activity.getLocale());
        cloned.setReactionsAdded(MessageReaction.cloneList(activity.getReactionsAdded()));
        cloned.setReactionsRemoved(MessageReaction.cloneList(activity.getReactionsRemoved()));
        cloned.setExpiration(activity.getExpiration());
        cloned.setMembersAdded(ChannelAccount.cloneList(activity.getMembersAdded()));
        cloned.setMembersRemoved(ChannelAccount.cloneList(activity.getMembersRemoved()));
        cloned.setTextFormat(activity.getTextFormat());
        cloned.setAttachmentLayout(activity.getAttachmentLayout());
        cloned.setTopicName(activity.getTopicName());
        if (activity.getListenFor() != null) {
            cloned.setListenFor(new ArrayList<String>(activity.getListenFor()));
        }
        for (Map.Entry<String, JsonNode> entry : activity.getProperties().entrySet()) {
            cloned.setProperties(entry.getKey(), entry.getValue());
        }
        if (cloned.getId() == null) {
            cloned.setId(String.format("g_%s", UUID.randomUUID().toString()));
        }
        return cloned;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String withType) {
        this.type = withType;
    }

    public boolean isType(String compareTo) {
        return StringUtils.equals((CharSequence)this.type, (CharSequence)compareTo);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String withId) {
        this.id = withId;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime withTimestamp) {
        this.timestamp = withTimestamp;
    }

    public OffsetDateTime getLocalTimestamp() {
        return this.localTimestamp;
    }

    public void setLocalTimestamp(OffsetDateTime withLocalTimestamp) {
        this.localTimestamp = withLocalTimestamp;
    }

    public String getLocalTimezone() {
        return this.localTimezone;
    }

    public void setLocalTimeZone(String withLocalTimezone) {
        this.localTimezone = withLocalTimezone;
    }

    public String getCallerId() {
        return this.callerId;
    }

    public void setCallerId(String withCallerId) {
        this.callerId = withCallerId;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String withServiceUrl) {
        this.serviceUrl = withServiceUrl;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String withChannelId) {
        this.channelId = withChannelId;
    }

    public ChannelAccount getFrom() {
        return this.from;
    }

    public void setFrom(ChannelAccount withFrom) {
        this.from = withFrom;
    }

    public ConversationAccount getConversation() {
        return this.conversation;
    }

    public void setConversation(ConversationAccount withConversation) {
        this.conversation = withConversation;
    }

    public ChannelAccount getRecipient() {
        return this.recipient;
    }

    public void setRecipient(ChannelAccount withRecipient) {
        this.recipient = withRecipient;
    }

    public TextFormatTypes getTextFormat() {
        return this.textFormat;
    }

    public void setTextFormat(TextFormatTypes withTextFormat) {
        this.textFormat = withTextFormat;
    }

    public AttachmentLayoutTypes getAttachmentLayout() {
        return this.attachmentLayout;
    }

    public void setAttachmentLayout(AttachmentLayoutTypes withAttachmentLayout) {
        this.attachmentLayout = withAttachmentLayout;
    }

    public List<MessageReaction> getReactionsAdded() {
        return this.reactionsAdded;
    }

    public void setReactionsAdded(List<MessageReaction> withReactionsAdded) {
        this.reactionsAdded = withReactionsAdded;
    }

    public List<MessageReaction> getReactionsRemoved() {
        return this.reactionsRemoved;
    }

    public void setReactionsRemoved(List<MessageReaction> withReactionsRemoved) {
        this.reactionsRemoved = withReactionsRemoved;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String withLocale) {
        this.locale = withLocale;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String withText) {
        this.text = withText;
    }

    public String getSpeak() {
        return this.speak;
    }

    public void setSpeak(String withSpeak) {
        this.speak = withSpeak;
    }

    public InputHints getInputHint() {
        return this.inputHint;
    }

    public void setInputHint(InputHints withInputHint) {
        this.inputHint = withInputHint;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String withSummary) {
        this.summary = withSummary;
    }

    public SuggestedActions getSuggestedActions() {
        return this.suggestedActions;
    }

    public void setSuggestedActions(SuggestedActions withSuggestedActions) {
        this.suggestedActions = withSuggestedActions;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> withAttachments) {
        this.attachments = withAttachments;
    }

    public void setAttachment(Attachment withAttachment) {
        this.setAttachments(Collections.singletonList(withAttachment));
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(List<Entity> withEntities) {
        this.entities = withEntities;
    }

    public void setMentions(List<Mention> withMentions) {
        List converted = withMentions.stream().filter(entity -> entity.getType().equalsIgnoreCase("mention")).map(entity -> Entity.getAs(entity, Entity.class)).collect(Collectors.toCollection(ArrayList::new));
        this.setEntities(converted);
    }

    public Object getChannelData() {
        return this.channelData;
    }

    public void setChannelData(Object withChannelData) {
        this.channelData = withChannelData;
    }

    public String getReplyToId() {
        return this.replyToId;
    }

    public void setReplyToId(String withReplyToId) {
        this.replyToId = withReplyToId;
    }

    public EndOfConversationCodes getCode() {
        return this.code;
    }

    public void setCode(EndOfConversationCodes withCode) {
        this.code = withCode;
    }

    public LocalDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(LocalDateTime withExpiration) {
        this.expiration = withExpiration;
    }

    public String getImportance() {
        return this.importance;
    }

    public void setImportance(String withImportance) {
        this.importance = withImportance;
    }

    public String getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(String withDeliveryMode) {
        this.deliveryMode = withDeliveryMode;
    }

    public List<String> getListenFor() {
        return this.listenFor;
    }

    public void setListenFor(List<String> withListenFor) {
        this.listenFor = withListenFor;
    }

    public List<TextHighlight> getTextHighlights() {
        return this.textHighlights;
    }

    public void setTextHighlights(List<TextHighlight> withTextHighlights) {
        this.textHighlights = withTextHighlights;
    }

    @JsonAnyGetter
    public Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    @JsonAnySetter
    public void setProperties(String key, JsonNode withValue) {
        this.properties.put(key, withValue);
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String withTopicName) {
        this.topicName = withTopicName;
    }

    public boolean getHistoryDisclosed() {
        return this.historyDisclosed;
    }

    public void setHistoryDisclosed(boolean withHistoryDisclosed) {
        this.historyDisclosed = withHistoryDisclosed;
    }

    public List<ChannelAccount> getMembersAdded() {
        return this.membersAdded;
    }

    public void setMembersAdded(List<ChannelAccount> withMembersAdded) {
        this.membersAdded = withMembersAdded;
    }

    public List<ChannelAccount> getMembersRemoved() {
        return this.membersRemoved;
    }

    public void setMembersRemoved(List<ChannelAccount> withMembersRemoved) {
        this.membersRemoved = withMembersRemoved;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String withLabel) {
        this.label = withLabel;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(String withValueType) {
        this.valueType = withValueType;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object withValue) {
        this.value = withValue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String withName) {
        this.name = withName;
    }

    public ConversationReference getRelatesTo() {
        return this.relatesTo;
    }

    public void setRelatesTo(ConversationReference withRelatesTo) {
        this.relatesTo = withRelatesTo;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String withAction) {
        this.action = withAction;
    }

    public Activity createTrace(String withName) {
        return this.createTrace(withName, null, null, null);
    }

    public Activity createTrace(String withName, Object withValue, String withValueType, String withLabel) {
        Activity reply = new Activity("trace");
        reply.setName(withName);
        reply.setLabel(withLabel);
        if (withValueType != null) {
            reply.setValueType(withValueType);
        } else {
            reply.setValueType(withValue != null ? withValue.getClass().getTypeName() : null);
        }
        reply.setValue(withValue);
        if (this.getRecipient() == null) {
            reply.setFrom(new ChannelAccount());
        } else {
            reply.setFrom(new ChannelAccount(this.getRecipient().getId(), this.getRecipient().getName()));
        }
        if (this.getFrom() == null) {
            reply.setRecipient(new ChannelAccount());
        } else {
            reply.setRecipient(new ChannelAccount(this.getFrom().getId(), this.getFrom().getName()));
        }
        reply.setReplyToId(this.getId());
        reply.setServiceUrl(this.getServiceUrl());
        reply.setChannelId(this.getChannelId());
        if (this.getConversation() != null) {
            reply.setConversation(new ConversationAccount(this.getConversation().isGroup(), this.getConversation().getId(), this.getConversation().getName()));
        }
        return reply;
    }

    public Activity createReply() {
        return this.createReply(null, null);
    }

    public Activity createReply(String withText) {
        return this.createReply(withText, null);
    }

    public Activity createReply(String withText, String withLocale) {
        Activity result = new Activity("message");
        result.setText(withText == null ? "" : withText);
        result.setLocale(withLocale == null ? this.getLocale() : withLocale);
        if (this.getRecipient() == null) {
            result.setFrom(new ChannelAccount());
        } else {
            result.setFrom(new ChannelAccount(this.getRecipient().getId(), this.getRecipient().getName()));
        }
        if (this.getFrom() == null) {
            result.setRecipient(new ChannelAccount());
        } else {
            result.setRecipient(new ChannelAccount(this.getFrom().getId(), this.getFrom().getName()));
        }
        result.setReplyToId(this.getId());
        result.setServiceUrl(this.getServiceUrl());
        result.setChannelId(this.getChannelId());
        if (this.getConversation() == null) {
            result.setConversation(new ConversationAccount());
        } else {
            result.setConversation(new ConversationAccount(this.getConversation().isGroup(), this.getConversation().getId(), this.getConversation().getName()));
        }
        result.setAttachments(new ArrayList<Attachment>());
        result.setEntities(new ArrayList<Entity>());
        return result;
    }

    public boolean hasContent() {
        if (!StringUtils.isBlank((CharSequence)this.getText())) {
            return true;
        }
        if (!StringUtils.isBlank((CharSequence)this.getSummary())) {
            return true;
        }
        if (this.getAttachments() != null && this.getAttachments().size() > 0) {
            return true;
        }
        return this.getChannelData() != null;
    }

    @JsonIgnore
    public List<Mention> getMentions() {
        if (this.getEntities() == null) {
            return Collections.emptyList();
        }
        return this.getEntities().stream().filter(entity -> entity.getType().equalsIgnoreCase("mention")).map(entity -> entity.getAs(Mention.class)).collect(Collectors.toCollection(ArrayList::new));
    }

    public <TypeT> TypeT getChannelData(Class<TypeT> classType) throws JsonProcessingException {
        if (this.getChannelData() == null) {
            return null;
        }
        if (classType.isInstance(this.getChannelData())) {
            return (TypeT)this.getChannelData();
        }
        JsonNode node = MAPPER.valueToTree(this.getChannelData());
        return (TypeT)MAPPER.treeToValue((TreeNode)node, classType);
    }

    public <TypeT> ResultPair<TypeT> tryGetChannelData(Class<TypeT> clsType) {
        Object instance = null;
        if (this.getChannelData() == null) {
            return new ResultPair<Object>(false, instance);
        }
        try {
            instance = this.getChannelData(clsType);
        }
        catch (JsonProcessingException e) {
            return new ResultPair<Object>(false, instance);
        }
        return new ResultPair<Object>(true, instance);
    }

    @JsonIgnore
    public ConversationReference getConversationReference() {
        ConversationReference conversationReference = new ConversationReference();
        conversationReference.setActivityId(this.getId());
        conversationReference.setUser(this.getFrom());
        conversationReference.setBot(this.getRecipient());
        conversationReference.setConversation(this.getConversation());
        conversationReference.setChannelId(this.getChannelId());
        conversationReference.setLocale(this.getLocale());
        conversationReference.setServiceUrl(this.getServiceUrl());
        return conversationReference;
    }

    @JsonIgnore
    public ConversationReference getReplyConversationReference(ResourceResponse reply) {
        ConversationReference reference = this.getConversationReference();
        reference.setActivityId(reply.getId());
        return reference;
    }

    protected boolean isActivity(String activityType) {
        String thisType = this.getType();
        if (thisType == null) {
            return false;
        }
        boolean result = StringUtils.startsWith((CharSequence)thisType.toLowerCase(), (CharSequence)activityType.toLowerCase());
        if (result) {
            boolean bl = result = thisType.length() == activityType.length();
            if (!result) {
                result = thisType.charAt(activityType.length()) == '/';
            }
        }
        return result;
    }

    public final Activity applyConversationReference(ConversationReference reference) {
        return this.applyConversationReference(reference, false);
    }

    public final Activity applyConversationReference(ConversationReference reference, boolean isIncoming) {
        this.setChannelId(reference.getChannelId());
        this.setServiceUrl(reference.getServiceUrl());
        this.setConversation(reference.getConversation());
        this.setLocale(reference.getLocale() == null ? this.getLocale() : reference.getLocale());
        if (isIncoming) {
            this.setFrom(reference.getUser());
            this.setRecipient(reference.getBot());
            if (reference.getActivityId() != null) {
                this.setId(reference.getActivityId());
            }
        } else {
            this.setFrom(reference.getBot());
            this.setRecipient(reference.getUser());
            if (reference.getActivityId() != null) {
                this.setReplyToId(reference.getActivityId());
            }
        }
        return this;
    }

    public Boolean isFromStreamingConnection() {
        if (this.serviceUrl != null) {
            Boolean isHttp = this.getServiceUrl().toLowerCase().startsWith("http");
            return isHttp == false;
        }
        return false;
    }

    public String removeRecipientMention() {
        if (this.getRecipient() == null) {
            return this.text;
        }
        return this.removeMentionText(this.getRecipient().getId());
    }

    public String removeMentionText(String withId) {
        this.setText(Activity.removeMentionTextImmutable(this, withId));
        return this.getText();
    }

    public static String removeRecipientMentionImmutable(Activity activity) {
        if (activity.getRecipient() == null) {
            return activity.getText();
        }
        return Activity.removeMentionTextImmutable(activity, activity.getRecipient().getId());
    }

    public static String removeMentionTextImmutable(Activity activity, String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return activity.getText();
        }
        String text = activity.getText();
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        for (Mention mention : activity.getMentions()) {
            if (!StringUtils.equals((CharSequence)mention.getMentioned().getId(), (CharSequence)id)) continue;
            text = StringUtils.isEmpty((CharSequence)mention.getText()) ? text.replaceAll("<at>" + mention.getMentioned().getName() + "</at>", "") : text.replaceAll(mention.getText(), "");
            text = text.trim();
        }
        return text;
    }

    public boolean isTeamsActivity() {
        return "msteams".equals(this.channelId);
    }

    public String teamsGetChannelId() {
        String teamsChannelId;
        try {
            TeamsChannelData teamsChannelData = this.getChannelData(TeamsChannelData.class);
            teamsChannelId = teamsChannelData.getTeamsChannelId();
            if (teamsChannelId == null && teamsChannelData.getChannel() != null) {
                teamsChannelId = teamsChannelData.getChannel().getId();
            }
        }
        catch (JsonProcessingException jpe) {
            teamsChannelId = null;
        }
        return teamsChannelId;
    }

    public TeamsChannelData teamsGetChannelData() {
        TeamsChannelData teamsChannelData;
        try {
            teamsChannelData = this.getChannelData(TeamsChannelData.class);
        }
        catch (JsonProcessingException jpe) {
            teamsChannelData = null;
        }
        return teamsChannelData;
    }

    public String teamsGetTeamId() {
        String teamId;
        try {
            TeamsChannelData teamsChannelData = this.getChannelData(TeamsChannelData.class);
            if (teamsChannelData == null) {
                return null;
            }
            teamId = teamsChannelData.getTeamsTeamId();
            if (teamId == null && teamsChannelData.getTeam() != null) {
                teamId = teamsChannelData.getTeam().getId();
            }
        }
        catch (JsonProcessingException jpe) {
            teamId = null;
        }
        return teamId;
    }

    public TeamInfo teamsGetTeamInfo() {
        TeamsChannelData teamsChannelData;
        try {
            teamsChannelData = this.getChannelData(TeamsChannelData.class);
        }
        catch (JsonProcessingException jpe) {
            teamsChannelData = null;
        }
        return teamsChannelData != null ? teamsChannelData.getTeam() : null;
    }

    public void teamsNotifyUser() {
        TeamsChannelData teamsChannelData;
        try {
            teamsChannelData = this.getChannelData(TeamsChannelData.class);
        }
        catch (JsonProcessingException jpe) {
            teamsChannelData = null;
        }
        if (teamsChannelData == null) {
            teamsChannelData = new TeamsChannelData();
        }
        teamsChannelData.setNotification(new NotificationInfo(true));
        this.setChannelData(teamsChannelData);
    }

    public void teamsNotifyUser(boolean alertInMeeting, String externalResourceUrl) {
        TeamsChannelData teamsChannelData;
        try {
            teamsChannelData = this.getChannelData(TeamsChannelData.class);
        }
        catch (JsonProcessingException jpe) {
            teamsChannelData = null;
        }
        if (teamsChannelData == null) {
            teamsChannelData = new TeamsChannelData();
        }
        teamsChannelData.setNotification(new NotificationInfo(true, externalResourceUrl));
        this.setChannelData(teamsChannelData);
    }

    public TeamsMeetingInfo teamsGetMeetingInfo() {
        TeamsChannelData teamsChannelData;
        try {
            teamsChannelData = this.getChannelData(TeamsChannelData.class);
        }
        catch (JsonProcessingException jpe) {
            teamsChannelData = null;
        }
        return teamsChannelData != null ? teamsChannelData.getMeeting() : null;
    }
}

