/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.schema;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Attachment {
    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String contentType;
    @JsonProperty(value="contentUrl")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String contentUrl;
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Object content;
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String name;
    @JsonProperty(value="thumbnailUrl")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String thumbnailUrl;
    private HashMap<String, JsonNode> properties = new HashMap();

    public static Attachment clone(Attachment attachment) {
        if (attachment == null) {
            return null;
        }
        Attachment cloned = new Attachment();
        cloned.setContentType(attachment.getContentType());
        cloned.setContent(attachment.getContent());
        cloned.setContentUrl(attachment.getContentUrl());
        cloned.setName(attachment.getName());
        cloned.setThumbnailUrl(attachment.getThumbnailUrl());
        for (String key : attachment.getProperties().keySet()) {
            cloned.setProperties(key, attachment.getProperties().get(key));
        }
        return cloned;
    }

    public static List<Attachment> cloneList(List<Attachment> attachments) {
        if (attachments == null) {
            return null;
        }
        return attachments.stream().map(attachment -> Attachment.clone(attachment)).collect(Collectors.toCollection(ArrayList::new));
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String withContentType) {
        this.contentType = withContentType;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setContentUrl(String withContentUrl) {
        this.contentUrl = withContentUrl;
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object withContent) {
        this.content = withContent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String withName) {
        this.name = withName;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setThumbnailUrl(String withThumbnailUrl) {
        this.thumbnailUrl = withThumbnailUrl;
    }

    @JsonAnyGetter
    public Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    @JsonAnySetter
    public void setProperties(String key, JsonNode value) {
        this.properties.put(key, value);
    }
}

