/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.schema.teams;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.bot.schema.PagedMembersResult;
import com.microsoft.bot.schema.teams.TeamsChannelAccount;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class TeamsPagedMembersResult {
    @JsonProperty(value="continuationToken")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String continuationToken;
    @JsonProperty(value="members")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<TeamsChannelAccount> members;

    public TeamsPagedMembersResult(PagedMembersResult pagedMembersResult) {
        this.continuationToken = pagedMembersResult.getContinuationToken();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.findAndRegisterModules();
        this.members = pagedMembersResult.getMembers().stream().map(channelAccount -> {
            try {
                JsonNode node = objectMapper.valueToTree(channelAccount);
                return (TeamsChannelAccount)objectMapper.treeToValue((TreeNode)node, TeamsChannelAccount.class);
            }
            catch (JsonProcessingException jpe) {
                return null;
            }
        }).collect(Collectors.toCollection(ArrayList::new));
        this.members.removeIf(Objects::isNull);
    }

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public void setContinuationToken(String withContinuationToken) {
        this.continuationToken = withContinuationToken;
    }

    public List<TeamsChannelAccount> getMembers() {
        return this.members;
    }

    public void setMembers(List<TeamsChannelAccount> withMembers) {
        this.members = withMembers;
    }
}

