/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class Serialization {
    private static ObjectMapper objectMapper = new ObjectMapper();

    private Serialization() {
    }

    public static <T> T getAs(Object obj, Class<T> classType) {
        try {
            return Serialization.safeGetAs(obj, classType);
        }
        catch (JsonProcessingException jpe) {
            return null;
        }
    }

    public static <T> T safeGetAs(Object obj, Class<T> classType) throws JsonProcessingException {
        if (obj == null) {
            return null;
        }
        JsonNode node = objectMapper.valueToTree(obj);
        return (T)objectMapper.treeToValue((TreeNode)node, classType);
    }

    public static Object clone(Object obj) {
        if (obj == null) {
            return null;
        }
        JsonNode node = objectMapper.valueToTree(obj);
        try {
            return objectMapper.treeToValue((TreeNode)node, obj.getClass());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T treeToValue(JsonNode src, Class<T> cls) {
        try {
            return (T)objectMapper.treeToValue((TreeNode)src, cls);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static JsonNode objectToTree(Object obj) {
        return objectMapper.valueToTree(obj);
    }

    public static <R> CompletableFuture<R> futureGetAs(Object obj, Class<R> classType) {
        CompletableFuture<R> futureResult = new CompletableFuture<R>();
        try {
            futureResult.complete(Serialization.safeGetAs(obj, classType));
        }
        catch (JsonProcessingException jpe) {
            futureResult.completeExceptionally(new CompletionException("Unable to deserialize", jpe));
        }
        return futureResult;
    }

    public static <T> T convert(Object source, Class<T> toClass) {
        return Serialization.getAs(source, toClass);
    }

    public static String toString(Object source) throws JsonProcessingException {
        return objectMapper.writeValueAsString(source);
    }

    public static String toStringSilent(Object source) {
        try {
            return objectMapper.writeValueAsString(source);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static JsonNode jsonToTree(String json) throws IOException {
        return objectMapper.readTree(json);
    }

    public static JsonNode asNode(String s) {
        return objectMapper.getNodeFactory().textNode(s);
    }

    public static JsonNode asNode(int i) {
        return objectMapper.getNodeFactory().numberNode(i);
    }

    public static JsonNode asNode(long l) {
        return objectMapper.getNodeFactory().numberNode(l);
    }

    public static JsonNode asNode(float f) {
        return objectMapper.getNodeFactory().numberNode(f);
    }

    public static JsonNode asNode(double d) {
        return objectMapper.getNodeFactory().numberNode(d);
    }

    public static JsonNode asNode(short s) {
        return objectMapper.getNodeFactory().numberNode(s);
    }

    public static JsonNode asNode(boolean b) {
        return objectMapper.getNodeFactory().booleanNode(b);
    }

    public static JsonNode asNode(byte b) {
        return objectMapper.getNodeFactory().numberNode(b);
    }

    public static ObjectNode createObjectNode() {
        return objectMapper.createObjectNode();
    }

    public static ArrayNode createArrayNode() {
        return objectMapper.createArrayNode();
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        objectMapper.findAndRegisterModules();
    }
}

