//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.intent.PatternMatchingEntity;
import com.microsoft.cognitiveservices.speech.util.KeyedItemHashMap;

/**
 * Represents a {@code PatternMatchingModel} used for intent recognition.
 */
public final class PatternMatchingModel extends LanguageUnderstandingModel{
    private KeyedItemHashMap<PatternMatchingIntent> intents;

    /**
     * This container of {@code PatternMatchingIntent} objects is used to define all the 
     * {@code PatternMatchingIntent} objects this model will look for.
     * @return A {@code KeyedItemHashMap} that contains all the Intents.
     */
    public KeyedItemHashMap<PatternMatchingIntent> getIntents() {
        return intents;
    }

    
    private KeyedItemHashMap<PatternMatchingEntity> entities;

    /**
     * This container of {@code PatternMatchingEntity} objects is used to define all the 
     * {@code PatternMatchingEntity} objects this model will look for.
     * @return A {@code KeyedItemHashMap} that contains all the Intents.
     */
    public KeyedItemHashMap<PatternMatchingEntity> getEntities() {
        return entities;
    }

    /** 
    *  Creates a {@code PatternMatchingModel} using the specified model ID.
    *  @param modelId A string that represents a unique ID for this model.
    */
    public PatternMatchingModel(String modelId) {
        this.modelId = modelId;
        intents = new KeyedItemHashMap();
        entities = new KeyedItemHashMap();
    }
}
