//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//

#include "com_microsoft_cognitiveservices_speech_Diagnostics.h"
#include "jni_utils.h"
#include "speechapi_c_diagnostics.h"
#include "speechapi_c_property_bag.h"
#include "speechapi_cxx_utils.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_Diagnostics
 * Method:    logConsoleStartLogging
 * Signature: (Z)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_Diagnostics_logConsoleStartLogging
  (JNIEnv *, jclass, jboolean logToStderr)
{
    diagnostics_log_console_start_logging((bool)logToStderr);
    return SPX_NOERROR;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_Diagnostics
 * Method:    logConsoleStopLogging
 * Signature: ()J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_Diagnostics_logConsoleStopLogging
  (JNIEnv *, jclass)
{
    diagnostics_log_console_stop_logging();
    return SPX_NOERROR;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_Diagnostics
 * Method:    logMemoryStartLogging
 * Signature: ()J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_Diagnostics_logMemoryStartLogging
  (JNIEnv*, jclass)
{
    diagnostics_log_memory_start_logging();
    return SPX_NOERROR;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_Diagnostics
 * Method:    logMemoryStopLogging
 * Signature: ()J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_Diagnostics_logMemoryStopLogging
  (JNIEnv*, jclass)
{
    diagnostics_log_memory_stop_logging();
    return SPX_NOERROR;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_Diagnostics
 * Method:    logMemoryDump
 * Signature: (Ljava/lang/String;Ljava/lang/String;ZZ)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_Diagnostics_logMemoryDump
  (JNIEnv* env, jclass, jstring filename, jstring linePrefix, jboolean emitToStdOut, jboolean emitToStdErr)
{
    const char* pszFilename = nullptr;
    const char* pszLinePrefix = nullptr;
    SPXHR result = SPX_NOERROR;
    try
    {
        pszFilename = GetStringUTFChars(env, filename);
        pszLinePrefix = GetStringUTFChars(env, linePrefix);
        diagnostics_log_memory_dump(pszFilename, pszLinePrefix, (bool)emitToStdOut, (bool)emitToStdErr);
    }
    catch (...)
    {
        result = SPXERR_RUNTIME_ERROR;
    }

    ReleaseStringUTFChars(env, filename, pszFilename);
    ReleaseStringUTFChars(env, linePrefix, pszLinePrefix);

    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_Diagnostics
 * Method:    logMemoryDumpOnExit
 * Signature: (Ljava/lang/String;Ljava/lang/String;ZZ)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_Diagnostics_logMemoryDumpOnExit
  (JNIEnv *env, jclass, jstring filename, jstring linePrefix, jboolean emitToStdOut, jboolean emitToStdErr)
{
    const char* pszFilename = nullptr;
    const char* pszLinePrefix = nullptr;
    SPXHR result = SPX_NOERROR;
    try
    {
        pszFilename = GetStringUTFChars(env, filename);
        pszLinePrefix = GetStringUTFChars(env, linePrefix);
        diagnostics_log_memory_dump_on_exit(pszFilename, pszLinePrefix, (bool)emitToStdOut, (bool)emitToStdErr);
    }
    catch (...)
    {
        result = SPXERR_RUNTIME_ERROR;
    }

    ReleaseStringUTFChars(env, filename, pszFilename);
    ReleaseStringUTFChars(env, linePrefix, pszLinePrefix);

    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_Diagnostics
 * Method:    logFileStartLogging
 * Signature: (Ljava/lang/String;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_Diagnostics_logFileStartLogging
(JNIEnv* env, jclass, jstring filename, jboolean append)
{
    SPXPROPERTYBAGHANDLE hpropbag = SPXHANDLE_INVALID;
    const char* pszFilename = nullptr;
    SPXHR result = SPX_NOERROR;
    try
    {
        pszFilename = GetStringUTFChars(env, filename);
        SPX_THROW_ON_FAIL(property_bag_create(&hpropbag));
        auto scopeGuard = Microsoft::CognitiveServices::Speech::Utils::MakeScopeGuard([&hpropbag]()
        {
            SPX_THROW_ON_FAIL(property_bag_release(hpropbag));
        });
        SPX_THROW_ON_FAIL(property_bag_set_string(hpropbag, -1, "SPEECH-LogFilename", pszFilename));
        SPX_THROW_ON_FAIL(property_bag_set_string(hpropbag, -1, "SPEECH-AppendToLogFile", (bool)append ? "1" : "0"));
        SPX_THROW_ON_FAIL(diagnostics_log_start_logging(hpropbag, nullptr));
    }
    catch (...)
    {
        result = SPXERR_RUNTIME_ERROR;
    }
    ReleaseStringUTFChars(env, filename, pszFilename);
    return result;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_Diagnostics
 * Method:    logFileStopLogging
 * Signature: ()J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_Diagnostics_logFileStopLogging
(JNIEnv*, jclass)
{
    SPXHR result = SPX_NOERROR;
    try
    {
        SPX_THROW_ON_FAIL(diagnostics_log_stop_logging());
    }
    catch (...)
    {
        result = SPXERR_RUNTIME_ERROR;
    }
    return result;
}
