//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_EmbeddedSpeechConfig.h"
#include "speechapi_c_embedded_speech_config.h"
#include "jni_utils.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_EmbeddedSpeechConfig
 * Method:    createEmbeddedSpeechConfig
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_EmbeddedSpeechConfig_createEmbeddedSpeechConfig
  (JNIEnv *env, jclass, jobject embeddedSpeechHandle)
{
    SPXSPEECHCONFIGHANDLE embedded = SPXHANDLE_INVALID;
    SPXHR hr = embedded_speech_config_create(&embedded);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, embeddedSpeechHandle, (jlong)embedded);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_EmbeddedSpeechConfig
 * Method:    embeddedSpeechConfigAddPath
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Ljava/lang/String;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_EmbeddedSpeechConfig_embeddedSpeechConfigAddPath
  (JNIEnv *env, jclass, jobject embeddedSpeechHandle, jstring path)
{
    const char *modelPath = GetStringUTFChars(env, path);
    jlong embedded = GetObjectHandle(env, embeddedSpeechHandle);
    SPXHR hr = embedded_speech_config_add_path((SPXSPEECHCONFIGHANDLE)embedded, modelPath);
    ReleaseStringUTFChars(env, path, modelPath);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_EmbeddedSpeechConfig
 * Method:    getNumSpeechRecognitionModels
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_EmbeddedSpeechConfig_getNumSpeechRecognitionModels
  (JNIEnv *env, jobject, jobject configHandle, jobject numModelsRef)
{
    uint32_t numModels = 0;
    jlong handle = GetObjectHandle(env, configHandle);
    SPXHR hr = embedded_speech_config_get_num_speech_reco_models((SPXSPEECHCONFIGHANDLE)handle, &numModels);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, numModelsRef, (jlong)numModels);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_EmbeddedSpeechConfig
 * Method:    getSpeechRecognitionModel
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;ILcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_EmbeddedSpeechConfig_getSpeechRecognitionModel
  (JNIEnv *env, jobject, jobject configHandle, jint index, jobject modelRef)
{
    jlong handle = GetObjectHandle(env, configHandle);
    SPXSPEECHRECOMODELHANDLE modelHandle = SPXHANDLE_INVALID;
    SPXHR hr = embedded_speech_config_get_speech_reco_model((SPXSPEECHCONFIGHANDLE)handle, (uint32_t)index, &modelHandle);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, modelRef, (jlong)modelHandle);
    }
    return (jlong)hr;
}
