//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_SpeechSynthesisBookmarkEventArgs.h"
#include "jni_utils.h"
#include "speechapi_c_synthesizer.h"
#include "speechapi_c_property_bag.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_SpeechSynthesisBookmarkEventArgs
 * Method:    getBookmarkEventValues
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_SpeechSynthesisBookmarkEventArgs_getBookmarkEventValues
  (JNIEnv *env, jobject , jobject eventHandle, jobject audioOffsetRef)
{
    jlong event = GetObjectHandle(env, eventHandle);
    uint64_t audioOffset = 0;
    SPXHR hr = synthesizer_bookmark_event_get_values((SPXEVENTHANDLE)event, &audioOffset);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, audioOffsetRef, (jlong)audioOffset);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_SpeechSynthesisBookmarkEventArgs
 * Method:    getTextFromHandle
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/StringRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_SpeechSynthesisBookmarkEventArgs_getTextFromHandle
  (JNIEnv *env, jobject, jobject eventHandle, jobject textStrRef)
{
    jlong event = GetObjectHandle(env, eventHandle);
    const char* str = synthesizer_event_get_text((SPXEVENTHANDLE)event);
    SPXHR hr = SPXERR_RUNTIME_ERROR;
    if (str != nullptr)
    {
        hr = SetStringObjectHandle(env, textStrRef, str);
        property_bag_free_string(str);
    }
    return hr;
}