//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech;

/**
 * Defines the boundary type of speech synthesis boundary event.
 * Added in version 1.21.0.
 */
public enum SpeechSynthesisBoundaryType
{
    /**
     * Indicates the boundary text is a word.
     */
    Word,

    /**
     * Indicates the boundary text is a punctuation.
     */
    Punctuation,

    /**
     * Indicates the boundary text is a sentence.
     */
    Sentence
}
