//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech;

/**
 * Define synthesis voice type.
 * Added in version 1.16.0
 */
public enum SynthesisVoiceType
{
    /**
     * Online neural voice.
     */
    OnlineNeural,

    /**
     * Online standard voice.
     */
    OnlineStandard,

    /**
     * Offline neural voice.
     */
    OfflineNeural,

    /**
     * Offline standard voice.
     */
    OfflineStandard
}
