//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech.audio;

/**
 * Represents audio processing constants used for specifying the processing in AudioProcessingOptions.
 */
public class AudioProcessingConstants {

    /**
     * Disables built-in input audio processing.
     */
    public static final int AUDIO_INPUT_PROCESSING_NONE = 0x00000000;

    /**
     * Enables default built-in input audio processing.
     */
    public static final int AUDIO_INPUT_PROCESSING_ENABLE_DEFAULT = 0x00000001;

    /**
     * Disables dereverberation in the audio processing pipeline.
     */
    public static final int AUDIO_INPUT_PROCESSING_DISABLE_DEREVERBERATION = 0x00000002;

    /**
     * Disables noise suppression in the audio processing pipeline.
     */
    public static final int AUDIO_INPUT_PROCESSING_DISABLE_NOISE_SUPPRESSION = 0x00000004;

    /**
     * Disables automatic gain control in the audio processing pipeline.
     */
    public static final int AUDIO_INPUT_PROCESSING_DISABLE_GAIN_CONTROL = 0x00000008;

    /**
     * Disables echo cancellation in the audio processing pipeline.
     */
    public static final int AUDIO_INPUT_PROCESSING_DISABLE_ECHO_CANCELLATION = 0x00000010;

    /**
     * Enable voice activity detection in input audio processing.
     */
    public static final int AUDIO_INPUT_PROCESSING_ENABLE_VOICE_ACTIVITY_DETECTION = 0x00000020;
}
