//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_ClassLanguageModel.h"
#include "jni_utils.h"
#include "speechapi_c_grammar.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_ClassLanguageModel
 * Method:    fromStorageId
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Ljava/lang/String;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_ClassLanguageModel_fromStorageId
  (JNIEnv* env, jclass, jobject grammarHandle, jstring storageId)
{
    SPXGRAMMARHANDLE grammar = SPXHANDLE_INVALID;
    const char* id = GetStringUTFChars(env, storageId);
    SPXHR hr = class_language_model_from_storage_id(&grammar, id);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, grammarHandle, (jlong)grammar);
    }
    ReleaseStringUTFChars(env, storageId, id);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_ClassLanguageModel
 * Method:    assignClass
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Ljava/lang/String;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_ClassLanguageModel_assignClass
  (JNIEnv *env, jobject, jobject clmHandle, jstring className, jobject grammarToAssign)
{
    jlong clm = GetObjectHandle(env, clmHandle);
    jlong grammar = GetObjectHandle(env, grammarToAssign);
    const char* clsName = GetStringUTFChars(env, className);
    SPXHR hr = class_language_model_assign_class((SPXGRAMMARHANDLE)clm, clsName, (SPXGRAMMARHANDLE)grammar);
    ReleaseStringUTFChars(env, className, clsName);
    return (jlong)hr;
}
