//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_HybridSpeechConfig.h"
#include "jni_utils.h"
#include "speechapi_c_factory.h"
#include "speechapi_c_hybrid_speech_config.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_HybridSpeechConfig
 * Method:    createHybridSpeechConfig
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_HybridSpeechConfig_createHybridSpeechConfig
  (JNIEnv *env, jclass, jobject hybridSpeechConfigHandle, jobject cloudSpeechConfigHandle, jobject embeddedSpeechConfigHandle)
{
    SPXSPEECHCONFIGHANDLE hybridConfig = SPXHANDLE_INVALID;
    jlong cloudConfig = GetObjectHandle(env, cloudSpeechConfigHandle);
    jlong embeddedConfig = GetObjectHandle(env, embeddedSpeechConfigHandle);
    SPXHR hr = hybrid_speech_config_create(&hybridConfig, (SPXSPEECHCONFIGHANDLE)cloudConfig, (SPXAUDIOCONFIGHANDLE)embeddedConfig);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, hybridSpeechConfigHandle, (jlong)hybridConfig);
    }
    return (jlong)hr;
}
