//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_util_SafeHandle.h"
#include "jni_utils.h"
#include "speechapi_c_audio_config.h"
#include "speechapi_c_audio_processing_options.h"
#include "speechapi_c_audio_stream_format.h"
#include "speechapi_c_audio_stream.h"
#include "speechapi_c_audio_stream.h"
#include "speechapi_c_auto_detect_source_lang_config.h"
#include "speechapi_c_connection.h"
#include "speechapi_c_conversation_translator.h"
#include "speechapi_c_conversation.h"
#include "speechapi_c_dialog_service_connector.h"
#include "speechapi_c_grammar.h"
#include "speechapi_c_intent_trigger.h"
#include "speechapi_c_json.h"
#include "speechapi_c_keyword_recognition_model.h"
#include "speechapi_c_language_understanding_model.h"
#include "speechapi_c_participant.h"
#include "speechapi_c_pronunciation_assessment_config.h"
#include "speechapi_c_property_bag.h"
#include "speechapi_c_recognizer.h"
#include "speechapi_c_source_lang_config.h"
#include "speechapi_c_speaker_recognition.h"
#include "speechapi_c_speech_config.h"
#include "speechapi_c_speech_recognition_model.h"
#include "speechapi_c_synthesizer.h"
#include "speechapi_c_translation_recognizer.h"
#include "speechapi_c_user.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseEventHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseEventHandle
(JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = recognizer_event_handle_release((SPXEVENTHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseRecognizerHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseRecognizerHandle
(JNIEnv *env, jobject , jlong handle)
{
    recognizer_recognizing_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    recognizer_recognized_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    recognizer_canceled_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    recognizer_session_started_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    recognizer_session_stopped_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    recognizer_speech_start_detected_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    recognizer_speech_end_detected_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    SPXHR hr = recognizer_handle_release((SPXRECOHANDLE)handle);
    RemoveGlobalReferenceFromHandle(env, (SPXHANDLE)handle);
    return (jlong)hr;
}


/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseConversationTranslatorHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseConversationTranslatorHandle
(JNIEnv *env, jobject , jlong handle)
{
    conversation_translator_session_started_set_callback((SPXCONVERSATIONTRANSLATORHANDLE)handle, nullptr, nullptr);
    conversation_translator_session_stopped_set_callback((SPXCONVERSATIONTRANSLATORHANDLE)handle, nullptr, nullptr);
    conversation_translator_canceled_set_callback((SPXCONVERSATIONTRANSLATORHANDLE)handle, nullptr, nullptr);
    conversation_translator_participants_changed_set_callback((SPXCONVERSATIONTRANSLATORHANDLE)handle, nullptr, nullptr);
    conversation_translator_conversation_expiration_set_callback((SPXCONVERSATIONTRANSLATORHANDLE)handle, nullptr, nullptr);
    conversation_translator_transcribing_set_callback((SPXCONVERSATIONTRANSLATORHANDLE)handle, nullptr, nullptr);
    conversation_translator_transcribed_set_callback((SPXCONVERSATIONTRANSLATORHANDLE)handle, nullptr, nullptr);
    conversation_translator_text_message_recevied_set_callback((SPXCONVERSATIONTRANSLATORHANDLE)handle, nullptr, nullptr);
    conversation_translator_connection_connected_set_callback((SPXCONVERSATIONTRANSLATORHANDLE)handle, nullptr, nullptr);
    conversation_translator_connection_disconnected_set_callback((SPXCONVERSATIONTRANSLATORHANDLE)handle, nullptr, nullptr);
    SPXHR hr = conversation_translator_handle_release((SPXCONVERSATIONTRANSLATORHANDLE)handle);
    RemoveGlobalReferenceFromHandle(env, (SPXHANDLE)handle);
    return (jlong)hr;
}


/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseSpeechConfigHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseSpeechConfigHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = speech_config_release((SPXSPEECHCONFIGHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseAudioConfigHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseAudioConfigHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = audio_config_release((SPXEVENTHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releasePropertyHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releasePropertyHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = property_bag_release((SPXPROPERTYBAGHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseRecognizerResultHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseRecognizerResultHandle
(JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = recognizer_result_handle_release((SPXRESULTHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseConnectionHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseConnectionHandle
(JNIEnv *env, jobject , jlong handle)
{
    connection_connected_set_callback((SPXCONNECTIONHANDLE)handle, nullptr, nullptr);
    connection_disconnected_set_callback((SPXCONNECTIONHANDLE)handle, nullptr, nullptr);
    connection_message_received_set_callback((SPXCONNECTIONHANDLE)handle, nullptr, nullptr);

    SPXHR hr = connection_handle_release((SPXCONNECTIONHANDLE)handle);
    RemoveGlobalReferenceFromHandle(env, (SPXHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseConnectionMessageHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseConnectionMessageHandle
(JNIEnv *env, jobject , jlong handle)
{
    SPXHR hr = connection_message_handle_release((SPXCONNECTIONMESSAGEHANDLE)handle);
    RemoveGlobalReferenceFromHandle(env, (SPXHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseConnectionMessageEventHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseConnectionMessageEventHandle
(JNIEnv *env, jobject , jlong handle)
{
    SPXHR hr = connection_message_received_event_handle_release((SPXEVENTHANDLE)handle);
    RemoveGlobalReferenceFromHandle(env, (SPXHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseAudioInputStreamHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseAudioInputStreamHandle
  (JNIEnv *env, jobject , jlong handle)
{
    SPXHR hr = audio_stream_release((SPXAUDIOSTREAMHANDLE)handle);
    RemoveGlobalReferenceFromHandle(env, (SPXHANDLE)handle);
    return (jlong)hr;
}
/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseAudioOutputStreamHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseAudioOutputStreamHandle
  (JNIEnv *env, jobject , jlong handle)
{
    SPXHR hr = audio_stream_release((SPXAUDIOSTREAMHANDLE)handle);
    RemoveGlobalReferenceFromHandle(env, (SPXHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseAudioStreamFormatHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseAudioStreamFormatHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = audio_stream_format_release((SPXAUDIOSTREAMFORMATHANDLE) handle);
    return (jlong)hr;
}
/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseKeywordModelHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseKeywordModelHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = keyword_recognition_model_handle_release((SPXKEYWORDHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseLanguageUnderstandingModelHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseLanguageUnderstandingModelHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = language_understanding_model__handle_release((SPXLUMODELHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseIntentTriggerHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseIntentTriggerHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = intent_trigger_handle_release((SPXAUDIOSTREAMFORMATHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseUserHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseUserHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = user_release_handle((SPXUSERHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseParticipantHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseParticipantHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = participant_release_handle((SPXPARTICIPANTHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseConversationHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseConversationHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = conversation_release_handle((SPXHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseDialogServiceConnectorHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseDialogServiceConnectorHandle
  (JNIEnv* env, jobject , jlong handle)
{
    dialog_service_connector_session_started_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    dialog_service_connector_session_stopped_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    dialog_service_connector_recognized_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    dialog_service_connector_recognizing_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    dialog_service_connector_canceled_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    dialog_service_connector_activity_received_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    dialog_service_connector_turn_status_received_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    SPXHR hr = dialog_service_connector_handle_release((SPXRECOHANDLE)handle);
    RemoveGlobalReferenceFromHandle(env, (SPXHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseTurnStatusReceivedEventHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseTurnStatusReceivedEventHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = dialog_service_connector_turn_status_received_release((SPXEVENTHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseActivityReceivedEventHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseActivityReceivedEventHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = dialog_service_connector_activity_received_event_release((SPXEVENTHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseAutoDetectSourceLanguageConfigHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseAutoDetectSourceLanguageConfigHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = auto_detect_source_lang_config_release((SPXAUTODETECTSOURCELANGCONFIGHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseSourceLanguageConfigHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseSourceLanguageConfigHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = source_lang_config_release((SPXSOURCELANGCONFIGHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseSynthesisEventHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseSynthesisEventHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = synthesizer_event_handle_release((SPXEVENTHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseSynthesisResultHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseSynthesisResultHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = synthesizer_result_handle_release((SPXRESULTHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseVoiceInfoHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseVoiceInfoHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = voice_info_handle_release((SPXRESULTHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseAudioDataStreamHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseAudioDataStreamHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = audio_data_stream_release((SPXAUDIOSTREAMHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseSynthesizerHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseSynthesizerHandle
  (JNIEnv* env, jobject , jlong handle)
{
    synthesizer_bookmark_reached_set_callback((SPXSYNTHHANDLE)handle, nullptr, nullptr);
    synthesizer_viseme_received_set_callback((SPXSYNTHHANDLE)handle, nullptr, nullptr);
    synthesizer_word_boundary_set_callback((SPXSYNTHHANDLE)handle, nullptr, nullptr);
    synthesizer_canceled_set_callback((SPXSYNTHHANDLE)handle, nullptr, nullptr);
    synthesizer_completed_set_callback((SPXSYNTHHANDLE)handle, nullptr, nullptr);
    synthesizer_synthesizing_set_callback((SPXSYNTHHANDLE)handle, nullptr, nullptr);
    synthesizer_started_set_callback((SPXSYNTHHANDLE)handle, nullptr, nullptr);
    SPXHR hr = synthesizer_handle_release((SPXSYNTHHANDLE)handle);
    RemoveGlobalReferenceFromHandle(env, (SPXHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseGrammarHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseGrammarHandle
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = grammar_handle_release((SPXGRAMMARHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseTranslationSynthesisHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseTranslationSynthesisHandle
(JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = translator_synthesizing_audio_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseKeywordRecognizerHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseKeywordRecognizerHandle
(JNIEnv* env, jobject , jlong handle)
{
    recognizer_recognized_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    recognizer_canceled_set_callback((SPXRECOHANDLE)handle, nullptr, nullptr);
    SPXHR hr = recognizer_handle_release((SPXRECOHANDLE)handle);
    RemoveGlobalReferenceFromHandle(env, (SPXHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releasePronunciationAssessmentConfig
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releasePronunciationAssessmentConfig
  (JNIEnv* , jobject , jlong handle)
{
    SPXHR hr = pronunciation_assessment_config_release((SPXPRONUNCIATIONASSESSMENTCONFIGHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseSpeakerRecognizerHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseSpeakerRecognizerHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = speaker_recognizer_release_handle((SPXSPEAKERIDHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseSpeakerIdentificationModelHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseSpeakerIdentificationModelHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = speaker_identification_model_release_handle((SPXSIMODELHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseSpeakerRecognitionResultHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseSpeakerRecognitionResultHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = recognizer_result_handle_release((SPXRESULTHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseSpeakerVerificationModelHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseSpeakerVerificationModelHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = speaker_verification_model_release_handle((SPXSVMODELHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseVoiceProfileResultHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseVoiceProfileResultHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = recognizer_result_handle_release((SPXRESULTHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseVoiceProfileEnrollmentResultHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseVoiceProfileEnrollmentResultHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = recognizer_result_handle_release((SPXRESULTHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseVoiceProfilePhraseResultHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseVoiceProfilePhraseResultHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = recognizer_result_handle_release((SPXRESULTHANDLE)handle);
    return (jlong)hr;
}


/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseVoiceProfileHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseVoiceProfileHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = voice_profile_release_handle((SPXVOICEPROFILEHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseVoiceProfileClientHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseVoiceProfileClientHandle
  (JNIEnv*, jobject, jlong handle)
{
    SPXHR hr = voice_profile_client_release_handle((SPXVOICEPROFILEHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseAudioProcessingOptionsHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseAudioProcessingOptionsHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = audio_processing_options_release((SPXAUDIOPROCESSINGOPTIONSHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseSpeechRecognitionModelHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseSpeechRecognitionModelHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = speech_recognition_model_handle_release((SPXSPEECHRECOMODELHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseJsonValueHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseJsonValueHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = ai_core_json_parser_handle_release((SPXHANDLE)handle);
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_util_SafeHandle
 * Method:    releaseJsonBuilderHandle
 * Signature: (J)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_util_SafeHandle_releaseJsonBuilderHandle
  (JNIEnv *, jobject, jlong handle)
{
    SPXHR hr = ai_core_json_builder_handle_release((SPXHANDLE)handle);
    return (jlong)hr;
}
