/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class SourceLanguageConfig
implements AutoCloseable {
    private SafeHandle configHandle = null;
    private boolean disposed = false;

    public static SourceLanguageConfig fromLanguage(String string) {
        Contracts.throwIfIllegalLanguage(string, "invalid language value");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SourceLanguageConfig.fromLanguage(intRef, string));
        return new SourceLanguageConfig(intRef.getValue());
    }

    public static SourceLanguageConfig fromLanguage(String string, String string2) {
        Contracts.throwIfIllegalLanguage(string, "invalid language value");
        Contracts.throwIfNullOrWhitespace(string2, "endpointId cannot be empty");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(SourceLanguageConfig.fromLanguageAndEndpointId(intRef, string, string2));
        return new SourceLanguageConfig(intRef.getValue());
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.configHandle != null) {
            this.configHandle.close();
            this.configHandle = null;
        }
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        return this.configHandle;
    }

    private SourceLanguageConfig(long l) {
        Contracts.throwIfNull(l, "handleValue");
        this.configHandle = new SafeHandle(l, SafeHandleType.SourceLanguageConfig);
    }

    private static final native long fromLanguage(IntRef var0, String var1);

    private static final native long fromLanguageAndEndpointId(IntRef var0, String var1, String var2);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

