//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech;

/**
 * Defines property ids.
 * Changed in version 1.8.0.
 */
public enum PropertyId {

    /**
     * The Cognitive Services Speech Service subscription key. If you are using an intent recognizer, you need
     * to specify the LUIS endpoint key for your particular LUIS app. Under normal circumstances, you shouldn't
     * have to use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.SpeechConfig#fromSubscription}
     */
    SpeechServiceConnection_Key (1000),

    /**
     * The Cognitive Services Speech Service endpoint (url). Under normal circumstances, you shouldn't
     * have to use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.SpeechConfig#fromEndpoint}
     * @see "NOTE: This endpoint is not the same as the endpoint used to obtain an access token."
     */
    SpeechServiceConnection_Endpoint (1001),

    /**
     * The Cognitive Services Speech Service region. Under normal circumstances, you shouldn't have to
     * use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.SpeechConfig#fromSubscription}, {@link com.microsoft.cognitiveservices.speech.SpeechConfig#fromEndpoint}, {@link com.microsoft.cognitiveservices.speech.SpeechConfig#fromHost},
     * {@link com.microsoft.cognitiveservices.speech.SpeechConfig#fromAuthorizationToken}.
     */
    SpeechServiceConnection_Region (1002),

    /**
     * The Cognitive Services Speech Service authorization token (aka access token). Under normal circumstances,
     * you shouldn't have to use this property directly.
     * <pre> Instead, use
     *      {@link com.microsoft.cognitiveservices.speech.SpeechConfig#fromAuthorizationToken},
     *      {@link com.microsoft.cognitiveservices.speech.intent.IntentRecognizer#setAuthorizationToken(String token)},
     *      {@link com.microsoft.cognitiveservices.speech.SpeechRecognizer#setAuthorizationToken},
     *      {@link com.microsoft.cognitiveservices.speech.translation.TranslationRecognizer#setAuthorizationToken}.
     * </pre>
     */
    SpeechServiceAuthorization_Token (1003),

    /**
     * The Cognitive Services Speech Service authorization type. Currently unused.
     */
    SpeechServiceAuthorization_Type (1004),

    /**
     * The Cognitive Services Custom Speech or Custom Voice Service endpoint id. Under normal circumstances, you shouldn't
     * have to use this property directly.
     * Instead use <pre>
     *      {@link com.microsoft.cognitiveservices.speech.SpeechConfig#setEndpointId}.
     *
     * NOTE: The endpoint id is available in the Custom Speech Portal, listed under Endpoint Details.
     * </pre>
     */
    SpeechServiceConnection_EndpointId (1005),

    /**
     * The Cognitive Services Speech Service host (url). Under normal circumstances, you shouldn't
     * have to use this property directly.
     * <pre> Instead, use
     *      {@link com.microsoft.cognitiveservices.speech.SpeechConfig#fromHost}.
     * </pre>
     */
    SpeechServiceConnection_Host (1006),

    /**
     * The host name of the proxy server used to connect to the Cognitive Services Speech Service. Under normal circumstances,
     * you shouldn't have to use this property directly.
     * <pre> Instead, use
     *      {@link com.microsoft.cognitiveservices.speech.SpeechConfig#setProxy}.
     *
     * NOTE: This property id was added in version 1.1.0.
     * </pre>
     */
    SpeechServiceConnection_ProxyHostName (1100),

    /**
     * The port of the proxy server used to connect to the Cognitive Services Speech Service. Under normal circumstances,
     * you shouldn't have to use this property directly.
     * <pre> Instead, use
     *      {@link com.microsoft.cognitiveservices.speech.SpeechConfig#setProxy}.
     *
     * NOTE: This property id was added in version 1.1.0.
     * </pre>
     */
    SpeechServiceConnection_ProxyPort (1101),

    /**
     * The user name of the proxy server used to connect to the Cognitive Services Speech Service. Under normal circumstances,
     * you shouldn't have to use this property directly.
     * <pre> Instead, use
     *      {@link com.microsoft.cognitiveservices.speech.SpeechConfig#setProxy}.
     *
     * NOTE: This property id was added in version 1.1.0.
     * </pre>
     */
    SpeechServiceConnection_ProxyUserName (1102),

    /**
     * The password of the proxy server used to connect to the Cognitive Services Speech Service. Under normal circumstances,
     * you shouldn't have to use this property directly.
     * <pre> Instead, use
     *      {@link com.microsoft.cognitiveservices.speech.SpeechConfig#setProxy}.
     *
     * NOTE: This property id was added in version 1.1.0.
     * </pre>
     */
    SpeechServiceConnection_ProxyPassword (1103),

    /**
     * The URL string built from speech configuration.
     * This property is intended to be read-only. The SDK is using it internally.
     * NOTE: Added in version 1.5.0.
     */
    SpeechServiceConnection_Url (1104),

    /**
     * The list of comma separated languages (BCP-47 format) used as target translation languages. Under normal circumstances,
     * you shouldn't have to use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.translation.SpeechTranslationConfig#addTargetLanguage},
     * {@link com.microsoft.cognitiveservices.speech.translation.SpeechTranslationConfig#getTargetLanguages}, {@link com.microsoft.cognitiveservices.speech.translation.TranslationRecognizer#getTargetLanguages}.
     */
    SpeechServiceConnection_TranslationToLanguages (2000),

    /**
     * The name of the Cognitive Service Text to Speech Service voice. Under normal circumstances, you shouldn't have to use this
     * property directly. Instead use {@link com.microsoft.cognitiveservices.speech.translation.SpeechTranslationConfig#setVoiceName}.
     * NOTE: Valid voice names can be found <a href="https://aka.ms/csspeech/voicenames">here</a>.
     */
    SpeechServiceConnection_TranslationVoice (2001),

    /**
     * Translation features. For internal use.
     */
    SpeechServiceConnection_TranslationFeatures (2002),

    /**
     * The Language Understanding Service region. Under normal circumstances, you shouldn't have to use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.intent.LanguageUnderstandingModel}.
     */
    SpeechServiceConnection_IntentRegion (2003),

    /**
     * The Cognitive Services Speech Service recognition mode. Can be "INTERACTIVE", "CONVERSATION", "DICTATION".
     * This property is intended to be read-only. The SDK is using it internally.
     */
    SpeechServiceConnection_RecoMode (3000),

    /**
     * The spoken language to be recognized (in BCP-47 format). Under normal circumstances, you shouldn't have to use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.SpeechConfig#setSpeechRecognitionLanguage}.
     */
    SpeechServiceConnection_RecoLanguage (3001),

    /**
     * The session id. This id is a universally unique identifier (aka UUID) representing a specific binding of an audio input stream
     * and the underlying speech recognition instance to which its bound. Under normal circumstances, you shouldn't have to use this
     * property directly.
     * Instead use {@link com.microsoft.cognitiveservices.speech.SessionEventArgs#getSessionId}.
     */
    Speech_SessionId (3002),

    /**
     * The string to specify the backend to be used for speech recognition;
     * allowed options are online and offline.
     * Under normal circumstances, you shouldn't use this property directly.
     * Currently the offline option is only valid when EmbeddedSpeechConfig is used.
     * Added in version 1.19.0
     */
    SpeechServiceConnection_RecoBackend (3004),

    /**
     * The name of the model to be used for speech recognition.
     * Under normal circumstances, you shouldn't use this property directly.
     * Currently this is only valid when EmbeddedSpeechConfig is used.
     * Added in version 1.19.0
     */
    SpeechServiceConnection_RecoModelName (3005),

    /**
     * The decryption key of the model to be used for speech recognition.
     * Under normal circumstances, you shouldn't use this property directly.
     * Currently this is only valid when EmbeddedSpeechConfig is used.
     * Added in version 1.19.0
     */
    SpeechServiceConnection_RecoModelKey (3006),

    /**
     * The spoken language to be synthesized (e.g. en-US)
     * Added in version 1.7.0
     */
    SpeechServiceConnection_SynthLanguage (3100),

    /**
     * The name of the TTS voice to be used for speech synthesis
     * Added in version 1.7.0
     */
    SpeechServiceConnection_SynthVoice (3101),

    /**
     * The string to specify TTS output audio format (e.g. riff-16khz-16bit-mono-pcm)
     * Added in version 1.7.0
     */
    SpeechServiceConnection_SynthOutputFormat (3102),

    /**
     * Indicates if use compressed audio format for speech synthesis audio transmission.
     * This property only affects when SpeechServiceConnection_SynthOutputFormat is set to a pcm format.
     * If this property is not set and GStreamer is available, SDK will use compressed format for synthesized audio transmission,
     * and decode it. You can set this property to "false" to use raw pcm format for transmission on wire.
     * Added in version 1.16.0
     */
    SpeechServiceConnection_SynthEnableCompressedAudioTransmission (3103),

    /**
     * The string to specify TTS backend; valid options are online and offline.
     * Under normal circumstances, you shouldn't have to use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig#fromPath} or {@link com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig#fromPaths}
     * to set the synthesis backend to offline.
     * Added in version 1.19.0
     */
    SpeechServiceConnection_SynthBackend (3110),

    /**
     * The data file path(s) for offline synthesis engine; only valid when synthesis backend is offline.
     * Under normal circumstances, you shouldn't have to use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig#fromPath} or {@link com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig#fromPaths}.
     * Added in version 1.19.0
     */
    SpeechServiceConnection_SynthOfflineDataPath (3112),

    /**
     * The name of the offline TTS voice to be used for speech synthesis.
     * Under normal circumstances, you shouldn't use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig#setSpeechSynthesisVoice}.
     * Added in version 1.19.0
     */
    SpeechServiceConnection_SynthOfflineVoice (3113),

    /**
     * The decryption key of the model to be used for speech synthesis.
     * Under normal circumstances, you shouldn't use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.EmbeddedSpeechConfig#setSpeechSynthesisVoice}.
     * Added in version 1.19.0
     */
    SpeechServiceConnection_SynthModelKey (3114),

    /**
     * The Cognitive Services Speech Service voices list api endpoint (url). Under normal circumstances,
     * you don't need to specify this property, SDK will construct it based on the region/host/endpoint of {@link com.microsoft.cognitiveservices.speech.SpeechConfig}.
     * Added in version 1.16.0
     */
    SpeechServiceConnection_VoicesListEndpoint (3130),

    /**
     *  The initial silence timeout value (in milliseconds) used by the service.
     *  Added in version 1.5.0
     */
    SpeechServiceConnection_InitialSilenceTimeoutMs (3200),

    /**
     *  The end silence timeout value (in milliseconds) used by the service.
     *  Added in version 1.5.0
     */
    SpeechServiceConnection_EndSilenceTimeoutMs (3201),

    /**
     *  A boolean value specifying whether audio logging is enabled in the service or not.
     *  Audio and content logs are stored either in Microsoft-owned storage, or in your own storage account linked
     *  to your Cognitive Services subscription (Bring Your Own Storage (BYOS) enabled Speech resource).
     *  Added in version 1.5.0
     */
    SpeechServiceConnection_EnableAudioLogging (3202),

    /**
     * The speech service connection language identifier mode.
     * Can be "AtStart" (the default), or "Continuous".
     * See <a href="https://aka.ms/speech/lid?pivots=programming-language-java">Language Identification</a> document.
     * Added in 1.25.0
     */
    SpeechServiceConnection_LanguageIdMode (3205),

    /**
     * The requested Cognitive Services Speech Service response output format (simple or detailed). Under normal circumstances, you shouldn't have
     * to use this property directly.
     * Instead use {@link com.microsoft.cognitiveservices.speech.SpeechConfig#setOutputFormat}.
     */
    SpeechServiceResponse_RequestDetailedResultTrueFalse (4000),

    /**
     * The requested Cognitive Services Speech Service response output profanity level. Currently unused.
     */
    SpeechServiceResponse_RequestProfanityFilterTrueFalse (4001),

    /**
     *  The requested Cognitive Services Speech Service response output profanity setting.
     *  Allowed values are "masked", "removed", and "raw".
     *  Added in version 1.5.0.
     */
    SpeechServiceResponse_ProfanityOption (4002),

    /**
     *  A string value specifying which post processing option should be used by service.
     *  Allowed values are "TrueText".
     *  Added in version 1.5.0
     */
    SpeechServiceResponse_PostProcessingOption (4003),

    /**
     *  A boolean value specifying whether to include word-level timestamps in the response result.
     *  Added in version 1.5.0
     */
    SpeechServiceResponse_RequestWordLevelTimestamps (4004),

    /**
     *  The number of times a word has to be in partial results to be returned.
     *  Added in version 1.5.0
     */
    SpeechServiceResponse_StablePartialResultThreshold (4005),

    /**
     *  A string value specifying the output format option in the response result. Internal use only.
     *  Added in version 1.5.0.
     */
    SpeechServiceResponse_OutputFormatOption (4006),

    /**
     * A boolean value specifying whether to include SNR (signal to noise ratio) in the response result.
     * Added in version 1.18.0
     */
    SpeechServiceResponse_RequestSnr (4007),

    /**
     *  A boolean value to request for stabilizing translation partial results by omitting words in the end.
     *  Added in version 1.5.0.
     */
    SpeechServiceResponse_TranslationRequestStablePartialResult (4100),


    /**
     * A boolean value specifying whether to request WordBoundary events.
     * Added in version 1.21.0.
     */
    SpeechServiceResponse_RequestWordBoundary (4200),

    /**
     * A boolean value specifying whether to request punctuation boundary in WordBoundary Events. Default is true.
     * Added in version 1.21.0.
     */
    SpeechServiceResponse_RequestPunctuationBoundary (4201),

    /**
     * A boolean value specifying whether to request sentence boundary in WordBoundary Events. Default is false.
     * Added in version 1.21.0.
     */
    SpeechServiceResponse_RequestSentenceBoundary (4202),

    /**
     * A boolean value specifying whether the SDK should synchronize synthesis metadata events,
     * (e.g. word boundary, viseme, etc.) to the audio playback. This only takes effect when the audio is played through the SDK.
     * Default is true.
     * If set to false, the SDK will fire the events as they come from the service, which may be out of sync with the audio playback.
     * Added in version 1.31.0.
     */
    SpeechServiceResponse_SynthesisEventsSyncToAudio (4210),

    /**
     * The Cognitive Services Speech Service response output (in JSON format). This property is available on recognition result objects only.
     */
    SpeechServiceResponse_JsonResult (5000),

    /**
     * The Cognitive Services Speech Service error details (in JSON format). Under normal circumstances, you shouldn't have to
     * use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.CancellationDetails#getErrorDetails}.
     */
    SpeechServiceResponse_JsonErrorDetails (5001),

    /**
     * The recognition latency in milliseconds. Read-only, available on final speech/translation/intent results.
     * This measures the latency between when an audio input is received by the SDK, and the moment the final result is received from the service.
     * The SDK computes the time difference between the last audio fragment from the audio input that is contributing to the final result, and the time the final result is received from the speech service.
     * Added in version 1.3.0.
     */
    SpeechServiceResponse_RecognitionLatencyMs (5002),

    /**
     * The recognition backend. Read-only, available on speech recognition results.
     * This indicates whether cloud (online) or embedded (offline) recognition was used to produce the result.
     */
    SpeechServiceResponse_RecognitionBackend (5003),

    /**
     * The speech synthesis first byte latency in milliseconds. Read-only, available on final speech synthesis results.
     * This measures the latency between when the synthesis is started to be processed, and the moment the first byte audio is available.
     * Added in version 1.17.0.
     */
    SpeechServiceResponse_SynthesisFirstByteLatencyMs (5010),

    /**
     * The speech synthesis all bytes latency in milliseconds. Read-only, available on final speech synthesis results.
     * This measures the latency between when the synthesis is started to be processed, and the moment the whole audio is synthesized.
     * Added in version 1.17.0.
     */
    SpeechServiceResponse_SynthesisFinishLatencyMs (5011),

    /**
     * The underrun time for speech synthesis in milliseconds. Read-only, available on results in SynthesisCompleted events.
     * This measures the total underrun time from {@link com.microsoft.cognitiveservices.speech.PropertyId#AudioConfig_PlaybackBufferLengthInMs} is filled to synthesis completed.
     * Added in version 1.17.0.
     */
    SpeechServiceResponse_SynthesisUnderrunTimeMs (5012),

    /**
     * The speech synthesis connection latency in milliseconds. Read-only, available on final speech synthesis results.
     * This measures the latency between when the synthesis is started to be processed, and the moment the HTTP/WebSocket connection is established.
     * Added in version 1.26.0
     */
    SpeechServiceResponse_SynthesisConnectionLatencyMs (5013),

    /**
     * The speech synthesis network latency in milliseconds. Read-only, available on final speech synthesis results.
     * This measures the network round trip time.
     * Added in version 1.26.0
     */
    SpeechServiceResponse_SynthesisNetworkLatencyMs (5014),

    /**
     * The speech synthesis service latency in milliseconds. Read-only, available on final speech synthesis results.
     * This measures the service processing time to synthesize the first byte of audio.
     * Added in version 1.26.0
     */
    SpeechServiceResponse_SynthesisServiceLatencyMs (5015),

    /**
     * Indicates which backend the synthesis is finished by. Read-only, available on speech synthesis results, except for the result in SynthesisStarted event.
     * Added in version 1.17.0.
     */
    SpeechServiceResponse_SynthesisBackend (5020),

    /**
     * The cancellation reason. Currently unused.
     */
    CancellationDetails_Reason (6000),

    /**
     * The cancellation text. Currently unused.
     */
    CancellationDetails_ReasonText (6001),

    /**
     * The cancellation detailed text. Currently unused.
     */
    CancellationDetails_ReasonDetailedText (6002),

    /**
     * The Language Understanding Service response output (in JSON format). Available via {@link com.microsoft.cognitiveservices.speech.intent.IntentRecognitionResult#toString}.
     */
    LanguageUnderstandingServiceResponse_JsonResult (7000),

    /**
     * The device name for audio render. Under normal circumstances, you shouldn't have to
     * use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.audio.AudioConfig#fromSpeakerOutput}.
     * Added in version 1.17.0
     */
    AudioConfig_DeviceNameForRender (8005),

    /**
     * Playback buffer length in milliseconds, default is 50 milliseconds.
     */
    AudioConfig_PlaybackBufferLengthInMs (8006),

    /**
     * Audio processing options in JSON format.
     */
    AudioConfig_AudioProcessingOptions (8007),

    /**
     * The file name to write logs.
     * Added in version 1.4.0.
     */
    Speech_LogFilename (9001),

    /**
     * A duration of detected silence, measured in milliseconds, after which speech-to-text will determine a spoken
     * phrase has ended and generate a final Recognized result. Configuring this timeout may be helpful in situations
     * where spoken input is significantly faster or slower than usual and default segmentation behavior consistently
     * yields results that are too long or too short. Segmentation timeout values that are inappropriately high or low
     * can negatively affect speech-to-text accuracy; this property should be carefully configured and the resulting
     * behavior should be thoroughly validated as intended.
     *
     * For more information about timeout configuration that includes discussion of default behaviors, please visit
     * https://aka.ms/csspeech/timeouts.
     */
    Speech_SegmentationSilenceTimeoutMs (9002),

    /**
     * Identifier used to connect to the backend service.
     * Added in version 1.5.0.
     */
    Conversation_ApplicationId (10000),

    /**
     * Type of dialog backend to connect to.
     * Added in version 1.7.0.
     */
    Conversation_DialogType (10001),

    /**
     * Silence timeout for listening
     * Added in version 1.5.0.
     */
    Conversation_Initial_Silence_Timeout (10002),

    /**
     * From id to be used on speech recognition activities
     * Added in version 1.5.0.
     */
    Conversation_From_Id (10003),

    /**
     * ConversationId for the session.
     * Added in version 1.8.0.
     */
    Conversation_Conversation_Id (10004),

    /**
     * Comma separated list of custom voice deployment ids.
     * Added in version 1.8.0.
     */
    Conversation_Custom_Voice_Deployment_Ids (10005),

    /**
     * Speech activity template, stamp properties in the template on the activity generated by the service for speech.
     * Added in version 1.10.0.
     */
    Conversation_Speech_Activity_Template (10006),

    /**
     * A boolean value that specifies whether the client should receive status messages and generate corresponding turnStatusReceived
     * events. Defaults to true.
     * Added in version 1.15.0.
     */
     Conversation_Request_Bot_Status_Messages (10008),

    /**
     * Additional identifying information, such as a Direct Line token, used to authenticate with the backend service.
     * Added in version 1.16.0.
     */
    Conversation_Connection_Id (10009),

    /**
     *  The auto detect source languages
     * Added in version 1.8.0.
     */
    SpeechServiceConnection_AutoDetectSourceLanguages (3300),

    /**
     * The auto detect source language result
     * Added in version 1.8.0.
     */
    SpeechServiceConnection_AutoDetectSourceLanguageResult (3301),

    /**
     * The user id associated to data buffer written by client when using Pull/Push audio mode streams.
     * Added in version 1.5.0.
     */
    DataBuffer_UserId (11002),

    /**
     * The time stamp associated to data buffer written by client when using Pull/Push audio mode streams.
     * The time stamp is a 64-bit value with a resolution of 90 kHz. The same as the presentation timestamp in an MPEG transport stream.
     * See https://en.wikipedia.org/wiki/Presentation_timestamp.
     * Added in version 1.5.0.
     */
    DataBuffer_TimeStamp (11001),

    /**
     * The reference text of the audio for pronunciation evaluation.
     * For this and the following pronunciation assessment parameters, see
     * https://docs.microsoft.com/azure/cognitive-services/speech-service/rest-speech-to-text#pronunciation-assessment-parameters for details.
     * Under normal circumstances, you shouldn't have to use this property directly.
     * Added in version 1.14.0
     */
    PronunciationAssessment_ReferenceText (12001),

    /**
     * The point system for pronunciation score calibration (FivePoint or HundredMark).
     * Under normal circumstances, you shouldn't have to use this property directly.
     * Added in version 1.14.0
     */
    PronunciationAssessment_GradingSystem (12002),

    /**
     * The pronunciation evaluation granularity (Phoneme, Word, or FullText).
     * Under normal circumstances, you shouldn't have to use this property directly.
     * Added in version 1.14.0
     */
    PronunciationAssessment_Granularity (12003),

    /**
     * Defines if enable miscue calculation.
     * With this enabled, the pronounced words will be compared to the reference text,
     * and will be marked with omission/insertion based on the comparison. The default setting is False.
     * Under normal circumstances, you shouldn't have to use this property directly.
     * Added in version 1.14.0
     */
    PronunciationAssessment_EnableMiscue (12005),

    /**
     * The pronunciation evaluation phoneme alphabet. The valid values are "SAPI" (default) and "IPA"
     * Under normal circumstances, you shouldn't have to use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.PronunciationAssessmentConfig#setPhonemeAlphabet}.
     * Added in version 1.20.0
     */
    PronunciationAssessment_PhonemeAlphabet (12006),

    /**
     * The pronunciation evaluation nbest phoneme count.
     * Under normal circumstances, you shouldn't have to use this property directly.
     * Instead, use {@link com.microsoft.cognitiveservices.speech.PronunciationAssessmentConfig#setNBestPhonemeCount}.
     * Added in version 1.20.0
     */
    PronunciationAssessment_NBestPhonemeCount (12007),

    /**
     * The json string of pronunciation assessment parameters
     * Under normal circumstances, you shouldn't have to use this property directly.
     * Added in version 1.14.0
     */
    PronunciationAssessment_Json (12009),

    /**
     * Pronunciation assessment parameters.
     * This property is intended to be read-only. The SDK is using it internally.
     * Added in version 1.14.0
     */
    PronunciationAssessment_Params (12010),

    /**
     * Version of Speaker Recognition to use.
     * Added in version 1.18.0
     */
    SpeakerRecognition_Api_Version (13001),

    /**
     * The name of a model to be used for speech translation.
     * Do not use this property directly.
     * Currently this is only valid when EmbeddedSpeechConfig is used.
     */
    SpeechTranslation_ModelName (13100),

    /**
     * The decryption key of a model to be used for speech translation.
     * Do not use this property directly.
     * Currently this is only valid when EmbeddedSpeechConfig is used.
     */
    SpeechTranslation_ModelKey (13101);


    private PropertyId(int id) {
        this.id = id;
    }

    /**
     * Returns the internal value property id
     *
     * @return the speech property id
     */
    public int getValue() { return this.id; }

    private final int id;
}
