//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include <string.h>
#include "com_microsoft_cognitiveservices_speech_speaker_SpeakerIdentificationModel.h"
#include "jni_utils.h"
#include "speechapi_c_speaker_recognition.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_SpeakerIdentificationModel
 * Method:    createSpeakerIdentificationModel
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_SpeakerIdentificationModel_createSpeakerIdentificationModel
  (JNIEnv *env, jclass, jobject modelHandle)
{
    SPXSIMODELHANDLE identificationModelHandle = SPXHANDLE_INVALID;
    SPXHR hr = speaker_identification_model_create(&identificationModelHandle);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, modelHandle, (jlong)identificationModelHandle);
    }
    return (jlong)hr;
}
/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_SpeakerIdentificationModel
 * Method:    speakerIdentificationModelAddProfile
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_SpeakerIdentificationModel_speakerIdentificationModelAddProfile
  (JNIEnv *env, jclass, jobject modelHandle, jobject profileHandle)
{
    jlong identificationModelHandle = GetObjectHandle(env, modelHandle);
    jlong voiceProfileHandle = GetObjectHandle(env, profileHandle);
    SPXHR hr = speaker_identification_model_add_profile((SPXSIMODELHANDLE)identificationModelHandle, (SPXVOICEPROFILEHANDLE)voiceProfileHandle);
    return (jlong)hr;
}
