//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
//
#include "com_microsoft_cognitiveservices_speech_speaker_SpeakerRecognizer.h"
#include "jni_utils.h"
#include "speechapi_c_factory.h"
#include "speechapi_c_speaker_recognition.h"

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_SpeakerRecognizer
 * Method:    createFromConfig
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/IntRef;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_SpeakerRecognizer_createFromConfig
  (JNIEnv *env, jobject, jobject recognizerHandle, jobject speechConfigHandle, jobject audioConfigHandle)
{
    SPXSPEAKERIDHANDLE recoHandle = SPXHANDLE_INVALID;
    jlong speechConfig = GetObjectHandle(env, speechConfigHandle);
    jlong audioConfig = GetObjectHandle(env, audioConfigHandle);
    SPXHR hr = recognizer_create_speaker_recognizer_from_config(&recoHandle, (SPXSPEECHCONFIGHANDLE)speechConfig, (SPXAUDIOCONFIGHANDLE)audioConfig);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, recognizerHandle, (jlong)recoHandle);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_SpeakerRecognizer
 * Method:    verifyOnce
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_SpeakerRecognizer_verifyOnce
  (JNIEnv *env, jobject, jobject recoHandle, jobject verificationModel, jobject resultHandle)
{
    SPXRESULTHANDLE result = SPXHANDLE_INVALID;
    jlong recognizerHandle = GetObjectHandle(env, recoHandle);
    jlong modelHandle = GetObjectHandle(env, verificationModel);
    SPXHR hr = speaker_recognizer_verify((SPXSPEAKERIDHANDLE)recognizerHandle, (SPXSVMODELHANDLE)modelHandle, &result);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, resultHandle, (jlong)result);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_SpeakerRecognizer
 * Method:    identifyOnce
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_SpeakerRecognizer_identifyOnce
  (JNIEnv *env, jobject, jobject recoHandle, jobject identificationModel, jobject resultHandle)
{
    SPXRESULTHANDLE result = SPXHANDLE_INVALID;
    jlong recognizerHandle = GetObjectHandle(env, recoHandle);
    jlong modelHandle = GetObjectHandle(env, identificationModel);
    SPXHR hr = speaker_recognizer_identify((SPXSPEAKERIDHANDLE)recognizerHandle, (SPXSIMODELHANDLE)modelHandle, &result);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, resultHandle, (jlong)result);
    }
    return (jlong)hr;
}

/*
 * Class:     com_microsoft_cognitiveservices_speech_speaker_SpeakerRecognizer
 * Method:    getPropertyBagFromRecognizerHandle
 * Signature: (Lcom/microsoft/cognitiveservices/speech/util/SafeHandle;Lcom/microsoft/cognitiveservices/speech/util/IntRef;)J
 */
JNIEXPORT jlong JNICALL Java_com_microsoft_cognitiveservices_speech_speaker_SpeakerRecognizer_getPropertyBagFromRecognizerHandle
  (JNIEnv *env, jobject, jobject recognizerHandle, jobject propertyHandle)
{
    SPXPROPERTYBAGHANDLE propHandle = SPXHANDLE_INVALID;
    jlong recoHandle = GetObjectHandle(env, recognizerHandle);
    SPXHR hr = speaker_recognizer_get_property_bag((SPXSPEAKERIDHANDLE)recoHandle, &propHandle);
    if (SPX_SUCCEEDED(hr))
    {
        SetObjectHandle(env, propertyHandle, (jlong)propHandle);
    }
    return (jlong)hr;
}
