/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.transcription;

import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class ConversationExpirationEventArgs
extends SessionEventArgs {
    private long minutesLeft;

    ConversationExpirationEventArgs(long l) {
        super(l);
        this.storeEventData(false);
    }

    ConversationExpirationEventArgs(long l, boolean bl) {
        super(l);
        this.storeEventData(bl);
    }

    public long getExpirationTime() {
        return this.minutesLeft;
    }

    @Override
    public String toString() {
        return "SessionId: " + this.getSessionId() + " Expiration: " + this.minutesLeft + ".";
    }

    private void storeEventData(boolean bl) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        IntRef intRef = new IntRef(0L);
        this.minutesLeft = this.getExpiration(this.eventHandle, intRef);
        Contracts.throwIfFail(intRef.getValue());
        if (bl) {
            super.close();
        }
    }

    private final native long getExpiration(SafeHandle var1, IntRef var2);
}

