//
// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE.md file in the project root for full license information.
//
package com.microsoft.cognitiveservices.speech;

import java.lang.AutoCloseable;

import com.microsoft.cognitiveservices.speech.util.Contracts;

/**
 * Represents the result of pronunciation assessment.
 * Added in version 1.33.0
 */
public final class ContentAssessmentResult
{
     /**
     * Gets the grammar score.
     * @return The grammar score
     */
    public Double getGrammarScore() {
        return grammarScore;
    }

    /**
     * Gets the vocabulary score.
     * @return The vocabulary score
     */
    public Double getVocabularyScore() {
        return vocabularyScore;
    }

    /**
     * Gets the topic score.
     * @return The topic score.
     */
    public Double getTopicScore() {
        return topicScore;
    }

    /*! \cond INTERNAL */

    protected ContentAssessmentResult(PropertyCollection properties) {
        grammarScore = Double.parseDouble(properties.getProperty("ContentAssessment_GrammarScore"));
        vocabularyScore = Double.parseDouble(properties.getProperty("ContentAssessment_VocabularyScore"));
        topicScore = Double.parseDouble(properties.getProperty("ContentAssessment_TopicScore"));
    }

    /*! \endcond */

    private double grammarScore;
    private double vocabularyScore;
    private double topicScore;
}
