/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SpeechSynthesisResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public class SpeechSynthesisEventArgs
implements AutoCloseable {
    private SpeechSynthesisResult result;
    private SafeHandle eventHandle;

    SpeechSynthesisEventArgs(long l) {
        Contracts.throwIfNull(l, "eventArgs");
        this.eventHandle = new SafeHandle(l, SafeHandleType.SynthesisEvent);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getSynthesisResult(this.eventHandle, intRef));
        this.result = new SpeechSynthesisResult(intRef);
    }

    public SpeechSynthesisResult getResult() {
        return this.result;
    }

    @Override
    public void close() {
        if (this.eventHandle != null) {
            this.eventHandle.close();
            this.eventHandle = null;
        }
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
    }

    private final native long getSynthesisResult(SafeHandle var1, IntRef var2);
}

