/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.AudioOutputStream;
import com.microsoft.cognitiveservices.speech.audio.AudioProcessingOptions;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStreamCallback;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class AudioConfig
implements AutoCloseable {
    private SafeHandle audioConfigHandle = null;
    private AudioInputStream inputStreamKeepAlive = null;
    private AudioOutputStream outputStreamKeepAlive = null;
    private boolean closeKeepAliveOnClose = false;
    private PropertyCollection propertyHandle = null;

    public static AudioConfig fromDefaultMicrophoneInput() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromDefaultMicrophone(intRef, null));
        return new AudioConfig(intRef);
    }

    public static AudioConfig fromDefaultMicrophoneInput(AudioProcessingOptions audioProcessingOptions) {
        Contracts.throwIfNull(audioProcessingOptions, "audioProcessingOptions");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromDefaultMicrophone(intRef, audioProcessingOptions.getImpl()));
        return new AudioConfig(intRef);
    }

    public static AudioConfig fromMicrophoneInput(String string) {
        Contracts.throwIfNull(string, "deviceName");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromMicrophoneInput(intRef, string, null));
        return new AudioConfig(intRef);
    }

    public static AudioConfig fromMicrophoneInput(String string, AudioProcessingOptions audioProcessingOptions) {
        Contracts.throwIfNull(string, "deviceName");
        Contracts.throwIfNull(audioProcessingOptions, "audioProcessingOptions");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromMicrophoneInput(intRef, string, audioProcessingOptions.getImpl()));
        return new AudioConfig(intRef);
    }

    public static AudioConfig fromWavFileInput(String string) {
        Contracts.throwIfNull(string, "fileName");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromWavFileName(intRef, string, null));
        return new AudioConfig(intRef);
    }

    public static AudioConfig fromWavFileInput(String string, AudioProcessingOptions audioProcessingOptions) {
        Contracts.throwIfNull(string, "fileName");
        Contracts.throwIfNull(audioProcessingOptions, "audioProcessingOptions");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromWavFileName(intRef, string, audioProcessingOptions.getImpl()));
        return new AudioConfig(intRef);
    }

    public static AudioConfig fromStreamInput(AudioInputStream audioInputStream) {
        Contracts.throwIfNull(audioInputStream, "audioStream");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromStream(intRef, audioInputStream.getImpl(), null));
        return new AudioConfig(intRef, audioInputStream);
    }

    public static AudioConfig fromStreamInput(AudioInputStream audioInputStream, AudioProcessingOptions audioProcessingOptions) {
        Contracts.throwIfNull(audioInputStream, "audioStream");
        Contracts.throwIfNull(audioProcessingOptions, "audioProcessingOptions");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromStream(intRef, audioInputStream.getImpl(), audioProcessingOptions.getImpl()));
        return new AudioConfig(intRef, audioInputStream);
    }

    public static AudioConfig fromStreamInput(PullAudioInputStreamCallback pullAudioInputStreamCallback) {
        Contracts.throwIfNull(pullAudioInputStreamCallback, "callback");
        PullAudioInputStream pullAudioInputStream = PullAudioInputStream.create(pullAudioInputStreamCallback);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromStream(intRef, pullAudioInputStream.getImpl(), null));
        AudioConfig audioConfig = new AudioConfig(intRef, pullAudioInputStream);
        audioConfig.closeKeepAliveOnClose = true;
        return audioConfig;
    }

    public static AudioConfig fromStreamInput(PullAudioInputStreamCallback pullAudioInputStreamCallback, AudioProcessingOptions audioProcessingOptions) {
        Contracts.throwIfNull(pullAudioInputStreamCallback, "callback");
        Contracts.throwIfNull(audioProcessingOptions, "audioProcessingOptions");
        PullAudioInputStream pullAudioInputStream = PullAudioInputStream.create(pullAudioInputStreamCallback);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromStream(intRef, pullAudioInputStream.getImpl(), audioProcessingOptions.getImpl()));
        AudioConfig audioConfig = new AudioConfig(intRef, pullAudioInputStream);
        audioConfig.closeKeepAliveOnClose = true;
        return audioConfig;
    }

    public static AudioConfig fromDefaultSpeakerOutput() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioOutputFromDefaultSpeaker(intRef));
        return new AudioConfig(intRef);
    }

    public static AudioConfig fromSpeakerOutput(String string) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioOutputFromSpeakerOutput(intRef, string));
        return new AudioConfig(intRef);
    }

    public static AudioConfig fromWavFileOutput(String string) {
        Contracts.throwIfNull(string, "fileName");
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioOutputFromWavFileName(intRef, string));
        return new AudioConfig(intRef);
    }

    public static AudioConfig fromStreamOutput(AudioOutputStream audioOutputStream) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioOutputFromStream(intRef, audioOutputStream.getImpl()));
        return new AudioConfig(intRef, audioOutputStream);
    }

    public AudioProcessingOptions getAudioProcessingOptions() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getAudioProcessingOptions(this.audioConfigHandle, intRef));
        return new AudioProcessingOptions(intRef);
    }

    @Override
    public void close() {
        if (this.inputStreamKeepAlive != null && this.closeKeepAliveOnClose) {
            this.inputStreamKeepAlive.close();
        }
        this.inputStreamKeepAlive = null;
        if (this.propertyHandle != null) {
            this.propertyHandle.close();
            this.propertyHandle = null;
        }
        if (this.audioConfigHandle != null) {
            this.audioConfigHandle.close();
            this.audioConfigHandle = null;
        }
    }

    public void setProperty(String string, String string2) {
        Contracts.throwIfNullOrWhitespace(string, "name");
        this.propertyHandle.setProperty(string, string2);
    }

    public void setProperty(PropertyId propertyId, String string) {
        this.propertyHandle.setProperty(propertyId, string);
    }

    AudioConfig(IntRef intRef) {
        Contracts.throwIfNull(intRef, "config");
        this.audioConfigHandle = new SafeHandle(intRef.getValue(), SafeHandleType.AudioConfig);
        this.inputStreamKeepAlive = null;
        this.outputStreamKeepAlive = null;
        IntRef intRef2 = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.audioConfigHandle, intRef2));
        this.propertyHandle = new PropertyCollection(intRef2);
    }

    AudioConfig(IntRef intRef, AudioInputStream audioInputStream) {
        this(intRef);
        this.inputStreamKeepAlive = audioInputStream;
    }

    AudioConfig(IntRef intRef, AudioOutputStream audioOutputStream) {
        this(intRef);
        this.outputStreamKeepAlive = audioOutputStream;
    }

    public SafeHandle getImpl() {
        return this.audioConfigHandle;
    }

    private static final native long createAudioInputFromWavFileName(IntRef var0, String var1, SafeHandle var2);

    private static final native long createAudioInputFromDefaultMicrophone(IntRef var0, SafeHandle var1);

    private static final native long createAudioInputFromMicrophoneInput(IntRef var0, String var1, SafeHandle var2);

    private static final native long createAudioInputFromStream(IntRef var0, SafeHandle var1, SafeHandle var2);

    private static final native long createAudioOutputFromDefaultSpeaker(IntRef var0);

    private static final native long createAudioOutputFromSpeakerOutput(IntRef var0, String var1);

    private static final native long createAudioOutputFromWavFileName(IntRef var0, String var1);

    private static final native long createAudioOutputFromStream(IntRef var0, SafeHandle var1);

    private final native long getAudioProcessingOptions(SafeHandle var1, IntRef var2);

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

