/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.util;

import com.microsoft.cognitiveservices.speech.util.EventHandler;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class EventHandlerImpl<T> {
    private ArrayList<EventHandler<T>> eventHandlerClients = new ArrayList();
    private Runnable notifyConnectedOnce;
    private boolean notifyConnectedOnceFired = false;
    private AtomicInteger runCounter;

    public EventHandlerImpl(AtomicInteger atomicInteger) {
        this.runCounter = atomicInteger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNotificationOnConnected(Runnable runnable) {
        EventHandlerImpl eventHandlerImpl = this;
        synchronized (eventHandlerImpl) {
            if (this.notifyConnectedOnceFired) {
                runnable.run();
            }
            this.notifyConnectedOnce = runnable;
        }
    }

    public boolean isUpdateNotificationOnConnectedFired() {
        return this.notifyConnectedOnceFired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventHandler<T> eventHandler) {
        EventHandlerImpl eventHandlerImpl = this;
        synchronized (eventHandlerImpl) {
            if (!this.notifyConnectedOnceFired) {
                this.notifyConnectedOnceFired = true;
                if (this.notifyConnectedOnce != null) {
                    this.notifyConnectedOnce.run();
                }
            }
        }
        this.eventHandlerClients.add(eventHandler);
    }

    public void removeEventListener(EventHandler<T> eventHandler) {
        this.eventHandlerClients.remove(eventHandler);
    }

    public void fireEvent(Object object, T t) {
        for (EventHandler<T> eventHandler : this.eventHandlerClients) {
            if (null != this.runCounter) {
                this.runCounter.incrementAndGet();
            }
            eventHandler.onEvent(object, t);
            if (null == this.runCounter) continue;
            this.runCounter.decrementAndGet();
        }
    }
}

