/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.NBestPhoneme;
import com.microsoft.cognitiveservices.speech.TimingResult;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class PhonemeLevelTimingResult
extends TimingResult {
    private String phoneme;
    private double accuracyScore;
    private List<NBestPhoneme> nbestPhonemes;

    PhonemeLevelTimingResult(JSONObject jSONObject) {
        super(jSONObject);
        JSONArray jSONArray;
        this.phoneme = jSONObject.optString("Phoneme");
        JSONObject jSONObject2 = jSONObject.optJSONObject("PronunciationAssessment");
        if (jSONObject2 != null) {
            this.accuracyScore = jSONObject2.optDouble("AccuracyScore");
        }
        if ((jSONArray = jSONObject.optJSONArray("NBestPhonemes")) != null) {
            this.nbestPhonemes = new ArrayList<NBestPhoneme>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                NBestPhoneme nBestPhoneme = new NBestPhoneme(jSONArray.optJSONObject(i));
                this.nbestPhonemes.add(nBestPhoneme);
            }
        }
    }

    public String getPhoneme() {
        return this.phoneme;
    }

    public double getAccuracyScore() {
        return this.accuracyScore;
    }

    public List<NBestPhoneme> getNBestPhonemes() {
        return this.nbestPhonemes;
    }
}

