/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PronunciationAssessmentGradingSystem;
import com.microsoft.cognitiveservices.speech.PronunciationAssessmentGranularity;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.Recognizer;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class PronunciationAssessmentConfig
implements AutoCloseable {
    private SafeHandle configHandle = null;
    private PropertyCollection propertyHandle = null;
    private boolean disposed = false;

    public PronunciationAssessmentConfig(String string, PronunciationAssessmentGradingSystem pronunciationAssessmentGradingSystem, PronunciationAssessmentGranularity pronunciationAssessmentGranularity, boolean bl) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(PronunciationAssessmentConfig.create(intRef, string, pronunciationAssessmentGradingSystem.getValue(), pronunciationAssessmentGranularity.getValue(), bl));
        this.init(intRef.getValue());
    }

    public PronunciationAssessmentConfig(String string, PronunciationAssessmentGradingSystem pronunciationAssessmentGradingSystem, PronunciationAssessmentGranularity pronunciationAssessmentGranularity) {
        this(string, pronunciationAssessmentGradingSystem, pronunciationAssessmentGranularity, false);
    }

    public PronunciationAssessmentConfig(String string) {
        this(string, PronunciationAssessmentGradingSystem.FivePoint, PronunciationAssessmentGranularity.Phoneme);
    }

    public static PronunciationAssessmentConfig fromJson(String string) {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(PronunciationAssessmentConfig.fromJson(intRef, string));
        return new PronunciationAssessmentConfig(intRef.getValue());
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.propertyHandle != null) {
            this.propertyHandle.close();
            this.propertyHandle = null;
        }
        if (this.configHandle != null) {
            this.configHandle.close();
            this.configHandle = null;
        }
        this.disposed = true;
    }

    public void setReferenceText(String string) {
        Contracts.throwIfNull(string, "value");
        this.propertyHandle.setProperty(PropertyId.PronunciationAssessment_ReferenceText, string);
    }

    public String getReferenceText() {
        return this.propertyHandle.getProperty(PropertyId.PronunciationAssessment_ReferenceText);
    }

    public void setPhonemeAlphabet(String string) {
        Contracts.throwIfNull(string, "value");
        this.propertyHandle.setProperty(PropertyId.PronunciationAssessment_PhonemeAlphabet, string);
    }

    public void setNBestPhonemeCount(int n) {
        this.propertyHandle.setProperty(PropertyId.PronunciationAssessment_NBestPhonemeCount, String.valueOf(n));
    }

    public void enableProsodyAssessment() {
        this.propertyHandle.setProperty(PropertyId.PronunciationAssessment_EnableProsodyAssessment, "true");
    }

    public void enableContentAssessmentWithTopic(String string) {
        Contracts.throwIfNull(string, "topic");
        this.propertyHandle.setProperty(PropertyId.PronunciationAssessment_ContentTopic, string);
    }

    public String toJson() {
        Contracts.throwIfNull(this.configHandle, "configHandle");
        return this.toJson(this.configHandle);
    }

    public void applyTo(Recognizer recognizer) {
        Contracts.throwIfNull(this.configHandle, "configHandle");
        Contracts.throwIfNull(recognizer, "recognizer");
        Contracts.throwIfNull(recognizer.getImpl(), "recoHandle");
        this.applyTo(this.configHandle, recognizer.getImpl());
    }

    public SafeHandle getImpl() {
        return this.configHandle;
    }

    private PronunciationAssessmentConfig(long l) {
        this.init(l);
    }

    private void init(long l) {
        Contracts.throwIfNull(l, "handleValue");
        this.configHandle = new SafeHandle(l, SafeHandleType.PronunciationAssessmentConfig);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.configHandle, intRef));
        this.propertyHandle = new PropertyCollection(intRef);
    }

    private static final native long create(IntRef var0, String var1, int var2, int var3, boolean var4);

    private static final native long fromJson(IntRef var0, String var1);

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);

    private final native long applyTo(SafeHandle var1, SafeHandle var2);

    private final native String toJson(SafeHandle var1);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

